/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.memory;

import com.octo.android.robospice.persistence.ObjectPersister;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.memory.CacheItem;
import com.octo.android.robospice.persistence.memory.LruCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import roboguice.util.temp.Ln;

public class LruCacheObjectPersister<T>
extends ObjectPersister<T> {
    private LruCache<Object, CacheItem<T>> lruCache;
    private ObjectPersister<T> decoratedPersister;

    public LruCacheObjectPersister(Class<T> clazz, LruCache<Object, CacheItem<T>> lruCache) {
        super(null, clazz);
        this.lruCache = lruCache;
    }

    public LruCacheObjectPersister(ObjectPersister<T> decoratedPersister, LruCache<Object, CacheItem<T>> lruCache) {
        super(decoratedPersister.getApplication(), decoratedPersister.getHandledClass());
        this.decoratedPersister = decoratedPersister;
        this.lruCache = lruCache;
    }

    public ObjectPersister<T> getDecoratedPersister() {
        return this.decoratedPersister;
    }

    public LruCache<Object, CacheItem<T>> getLruCache() {
        return this.lruCache;
    }

    @Override
    public T loadDataFromCache(Object cacheKey, long maxTimeInCacheBeforeExpiry) throws CacheLoadingException {
        boolean dataIsNotExpired;
        CacheItem<T> cacheItem = this.lruCache.get(cacheKey);
        if (cacheItem == null) {
            Ln.d("Miss from lru cache for %s", cacheKey);
            if (this.decoratedPersister != null) {
                T data = this.decoratedPersister.loadDataFromCache(cacheKey, maxTimeInCacheBeforeExpiry);
                if (data == null) {
                    return null;
                }
                CacheItem<T> item = new CacheItem<T>(this.decoratedPersister.getCreationDateInCache(cacheKey), data);
                Ln.d("Put in lru cache after miss", new Object[0]);
                this.lruCache.put(cacheKey, item);
                return data;
            }
            return null;
        }
        Ln.d("Hit from lru cache for %s", cacheKey);
        boolean dataCanExpire = maxTimeInCacheBeforeExpiry != 0L;
        boolean bl = dataIsNotExpired = System.currentTimeMillis() - cacheItem.getCreationDate() <= maxTimeInCacheBeforeExpiry;
        if (!dataCanExpire || dataIsNotExpired) {
            return cacheItem.getData();
        }
        return null;
    }

    @Override
    public T saveDataToCacheAndReturnData(T data, Object cacheKey) throws CacheSavingException {
        CacheItem<T> itemToCache = new CacheItem<T>(data);
        this.lruCache.put(cacheKey, itemToCache);
        Ln.d("Put in lru cache for %s", cacheKey);
        if (this.decoratedPersister != null) {
            this.decoratedPersister.saveDataToCacheAndReturnData(data, cacheKey);
        }
        return data;
    }

    @Override
    public boolean isDataInCache(Object cacheKey, long maxTimeInCacheBeforeExpiry) {
        CacheItem<T> cacheItem = this.lruCache.get(cacheKey);
        if (cacheItem == null) {
            if (this.decoratedPersister != null) {
                return this.decoratedPersister.isDataInCache(cacheKey, maxTimeInCacheBeforeExpiry);
            }
            return false;
        }
        boolean dataCanExpire = maxTimeInCacheBeforeExpiry != 0L;
        boolean dataIsNotExpired = System.currentTimeMillis() - cacheItem.getCreationDate() <= maxTimeInCacheBeforeExpiry;
        return !dataCanExpire || dataIsNotExpired;
    }

    @Override
    public long getCreationDateInCache(Object cacheKey) throws CacheLoadingException {
        CacheItem<T> cacheItem = this.lruCache.get(cacheKey);
        if (cacheItem != null) {
            return cacheItem.getCreationDate();
        }
        if (this.decoratedPersister != null) {
            return this.decoratedPersister.getCreationDateInCache(cacheKey);
        }
        throw new CacheLoadingException("Data could not be found in cache for cacheKey=" + cacheKey);
    }

    @Override
    public List<T> loadAllDataFromCache() throws CacheLoadingException {
        if (this.decoratedPersister != null) {
            return this.decoratedPersister.loadAllDataFromCache();
        }
        Map<Object, CacheItem<T>> cacheMap = this.lruCache.snapshot();
        ArrayList<T> allData = new ArrayList<T>();
        for (CacheItem<T> item : cacheMap.values()) {
            allData.add(item.getData());
        }
        return allData;
    }

    @Override
    public List<Object> getAllCacheKeys() {
        if (this.decoratedPersister != null) {
            return this.decoratedPersister.getAllCacheKeys();
        }
        return new ArrayList<Object>(this.lruCache.snapshot().keySet());
    }

    @Override
    public boolean removeDataFromCache(Object cacheKey) {
        boolean result = false;
        if (this.decoratedPersister != null) {
            result = this.decoratedPersister.removeDataFromCache(cacheKey);
        }
        return result || this.lruCache.remove(cacheKey) != null;
    }

    @Override
    public void removeAllDataFromCache() {
        this.lruCache.evictAll();
        if (this.decoratedPersister != null) {
            this.decoratedPersister.removeAllDataFromCache();
        }
    }
}

