/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.binary;

import android.app.Application;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.file.InFileObjectPersister;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class InFileBitmapObjectPersister
extends InFileObjectPersister<Bitmap> {
    private static final int DEFAULT_QUALITY = 100;
    private Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
    private BitmapFactory.Options decodingOptions = null;
    private int quality = 100;

    public InFileBitmapObjectPersister(Application application) throws CacheCreationException {
        super(application, Bitmap.class);
    }

    public InFileBitmapObjectPersister(Application application, File cacheFolder) throws CacheCreationException {
        super(application, Bitmap.class, cacheFolder);
    }

    @Override
    protected Bitmap readCacheDataFromFile(File file) throws CacheLoadingException {
        Bitmap data;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file.getAbsolutePath());
            data = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)this.decodingOptions);
        }
        catch (Throwable ex) {
            throw new CacheLoadingException(String.format("Found the file %s but could not decode bitmap.", file.getAbsolutePath()), ex);
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        if (data == null) {
            throw new CacheLoadingException(String.format("Found the file %s but could not decode bitmap.", file.getAbsolutePath()));
        }
        return data;
    }

    @Override
    public Bitmap saveDataToCacheAndReturnData(Bitmap data, Object cacheKey) throws CacheSavingException {
        Bitmap bitmap;
        BufferedOutputStream out = null;
        try {
            File cacheFile = this.getCacheFile(cacheKey);
            out = new BufferedOutputStream(new FileOutputStream(cacheFile));
            boolean didCompress = data.compress(this.compressFormat, this.quality, (OutputStream)out);
            if (!didCompress) {
                throw new CacheSavingException(String.format("Could not compress bitmap for path: %s", this.getCacheFile(cacheKey).getAbsolutePath()));
            }
            bitmap = data;
        }
        catch (IOException e) {
            try {
                throw new CacheSavingException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return bitmap;
    }

    public BitmapFactory.Options getDecodingOptions() {
        return this.decodingOptions;
    }

    public void setDecodingOptions(BitmapFactory.Options decodingOptions) {
        this.decodingOptions = decodingOptions;
    }

    public Bitmap.CompressFormat getCompressFormat() {
        return this.compressFormat;
    }

    public void setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }
}

