/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence;

import com.octo.android.robospice.persistence.CacheCleaner;
import com.octo.android.robospice.persistence.ICacheManager;
import com.octo.android.robospice.persistence.ObjectPersister;
import com.octo.android.robospice.persistence.ObjectPersisterFactory;
import com.octo.android.robospice.persistence.Persister;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import roboguice.util.temp.Ln;

public class CacheManager
implements ICacheManager {
    private Collection<Persister> listPersister = new ArrayList<Persister>();
    private Map<ObjectPersisterFactory, List<ObjectPersister<?>>> mapFactoryToPersister = new HashMap();

    @Override
    public void addPersister(Persister persister) {
        this.listPersister.add(persister);
        if (persister instanceof ObjectPersisterFactory) {
            this.mapFactoryToPersister.put((ObjectPersisterFactory)persister, new CopyOnWriteArrayList());
        } else if (!(persister instanceof ObjectPersister)) {
            throw new RuntimeException(this.getClass().getSimpleName() + " only supports " + ObjectPersister.class.getSimpleName() + " or " + ObjectPersisterFactory.class.getSimpleName() + " instances.");
        }
    }

    @Override
    public void removePersister(Persister persister) {
        this.listPersister.remove(persister);
        if (persister instanceof ObjectPersisterFactory) {
            this.mapFactoryToPersister.remove(persister);
        }
    }

    @Override
    public <T> T loadDataFromCache(Class<T> clazz, Object cacheKey, long maxTimeInCacheBeforeExpiry) throws CacheLoadingException, CacheCreationException {
        return this.getObjectPersister(clazz).loadDataFromCache(cacheKey, maxTimeInCacheBeforeExpiry);
    }

    @Override
    public <T> T saveDataToCacheAndReturnData(T data, Object cacheKey) throws CacheSavingException, CacheCreationException {
        ObjectPersister<?> classCacheManager = this.getObjectPersister(data.getClass());
        return (T)classCacheManager.saveDataToCacheAndReturnData(data, cacheKey);
    }

    @Override
    public boolean isDataInCache(Class<?> clazz, Object cacheKey, long maxTimeInCacheBeforeExpiry) throws CacheCreationException {
        return this.getObjectPersister(clazz).isDataInCache(cacheKey, maxTimeInCacheBeforeExpiry);
    }

    @Override
    public Date getDateOfDataInCache(Class<?> clazz, Object cacheKey) throws CacheLoadingException, CacheCreationException {
        return new Date(this.getObjectPersister(clazz).getCreationDateInCache(cacheKey));
    }

    @Override
    public boolean removeDataFromCache(Class<?> clazz, Object cacheKey) {
        try {
            return this.getObjectPersister(clazz).removeDataFromCache(cacheKey);
        }
        catch (CacheCreationException e) {
            Ln.e(e);
            return false;
        }
    }

    @Override
    public void removeAllDataFromCache(Class<?> clazz) {
        try {
            this.getObjectPersister(clazz).removeAllDataFromCache();
        }
        catch (CacheCreationException e) {
            Ln.e(e);
        }
    }

    @Override
    public <T> List<Object> getAllCacheKeys(Class<T> clazz) {
        try {
            return this.getObjectPersister(clazz).getAllCacheKeys();
        }
        catch (CacheCreationException e) {
            Ln.e(e);
            return Collections.emptyList();
        }
    }

    @Override
    public <T> List<T> loadAllDataFromCache(Class<T> clazz) throws CacheLoadingException, CacheCreationException {
        return this.getObjectPersister(clazz).loadAllDataFromCache();
    }

    @Override
    public void removeAllDataFromCache() {
        for (Persister persister : this.listPersister) {
            if (persister instanceof CacheCleaner) {
                ((CacheCleaner)((Object)persister)).removeAllDataFromCache();
            }
            if (!(persister instanceof ObjectPersisterFactory)) continue;
            ObjectPersisterFactory factory = (ObjectPersisterFactory)persister;
            List<ObjectPersister<?>> listPersisterForFactory = this.mapFactoryToPersister.get(factory);
            for (ObjectPersister<?> objectPersister : listPersisterForFactory) {
                objectPersister.removeAllDataFromCache();
            }
        }
    }

    protected <T> ObjectPersister<T> getObjectPersister(Class<T> clazz) throws CacheCreationException {
        for (Persister persister : this.listPersister) {
            ObjectPersisterFactory factory;
            if (!persister.canHandleClass(clazz)) continue;
            if (persister instanceof ObjectPersister) {
                return (ObjectPersister)persister;
            }
            if (!(persister instanceof ObjectPersisterFactory) || !(factory = (ObjectPersisterFactory)persister).canHandleClass(clazz)) continue;
            List<ObjectPersister<?>> listPersisterForFactory = this.mapFactoryToPersister.get(factory);
            for (ObjectPersister<T> objectPersister : listPersisterForFactory) {
                if (!objectPersister.canHandleClass(clazz)) continue;
                return objectPersister;
            }
            ObjectPersister<T> newPersister = factory.createObjectPersister(clazz);
            newPersister.setAsyncSaveEnabled(factory.isAsyncSaveEnabled());
            listPersisterForFactory.add(newPersister);
            return newPersister;
        }
        throw new RuntimeException("Class " + clazz.getName() + " is not handled by any registered ObjectPersister. Please add a Persister for this class inside the CacheManager of your SpiceService.");
    }
}

