/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.base.impl;

import com.nytimes.android.external.cache3.Cache;
import com.nytimes.android.external.cache3.CacheBuilder;
import com.nytimes.android.external.store3.base.impl.MemoryPolicy;
import com.nytimes.android.external.store3.base.impl.StoreDefaults;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.util.concurrent.TimeUnit;

public final class CacheFactory {
    private CacheFactory() {
    }

    static <Key, Parsed> Cache<Key, Maybe<Parsed>> createCache(MemoryPolicy memoryPolicy) {
        return CacheFactory.createBaseCache(memoryPolicy);
    }

    static <Key, Parsed> Cache<Key, Single<Parsed>> createInflighter(MemoryPolicy memoryPolicy) {
        return CacheFactory.createBaseInFlighter(memoryPolicy);
    }

    public static <Key, Parsed> Cache<Key, Observable<Parsed>> createRoomCache(MemoryPolicy memoryPolicy) {
        return CacheFactory.createBaseCache(memoryPolicy);
    }

    public static <Key, Parsed> Cache<Key, Observable<Parsed>> createRoomInflighter(MemoryPolicy memoryPolicy) {
        return CacheFactory.createBaseInFlighter(memoryPolicy);
    }

    private static <Key, Value> Cache<Key, Value> createBaseInFlighter(MemoryPolicy memoryPolicy) {
        long maximumInFlightRequestsDuration;
        long expireAfterToSeconds = memoryPolicy == null ? StoreDefaults.getCacheTTLTimeUnit().toSeconds(StoreDefaults.getCacheTTL()) : memoryPolicy.getExpireAfterTimeUnit().toSeconds(memoryPolicy.getExpireAfterWrite());
        if (expireAfterToSeconds > (maximumInFlightRequestsDuration = TimeUnit.MINUTES.toSeconds(1L))) {
            return CacheBuilder.newBuilder().expireAfterWrite(maximumInFlightRequestsDuration, TimeUnit.SECONDS).build();
        }
        long expireAfter = memoryPolicy == null ? StoreDefaults.getCacheTTL() : memoryPolicy.getExpireAfterWrite();
        TimeUnit expireAfterUnit = memoryPolicy == null ? StoreDefaults.getCacheTTLTimeUnit() : memoryPolicy.getExpireAfterTimeUnit();
        return CacheBuilder.newBuilder().expireAfterWrite(expireAfter, expireAfterUnit).build();
    }

    private static <Key, Value> Cache<Key, Value> createBaseCache(MemoryPolicy memoryPolicy) {
        if (memoryPolicy == null) {
            return CacheBuilder.newBuilder().maximumSize(StoreDefaults.getCacheSize()).expireAfterWrite(StoreDefaults.getCacheTTL(), StoreDefaults.getCacheTTLTimeUnit()).build();
        }
        if (memoryPolicy.getExpireAfterAccess() == -1L) {
            return CacheBuilder.newBuilder().maximumSize(memoryPolicy.getMaxSize()).expireAfterWrite(memoryPolicy.getExpireAfterWrite(), memoryPolicy.getExpireAfterTimeUnit()).build();
        }
        return CacheBuilder.newBuilder().maximumSize(memoryPolicy.getMaxSize()).expireAfterAccess(memoryPolicy.getExpireAfterAccess(), memoryPolicy.getExpireAfterTimeUnit()).build();
    }
}

