/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.cache.CacheBuilder;
import com.nytimes.android.external.store.base.impl.MemoryPolicy;
import com.nytimes.android.external.store.base.impl.StoreDefaults;
import java.util.concurrent.TimeUnit;
import rx.Observable;

final class CacheFactory {
    private CacheFactory() {
    }

    static <Key, Parsed> Cache<Key, Observable<Parsed>> createCache(MemoryPolicy memoryPolicy) {
        if (memoryPolicy == null) {
            return CacheBuilder.newBuilder().maximumSize(StoreDefaults.getCacheSize()).expireAfterWrite(StoreDefaults.getCacheTTL(), StoreDefaults.getCacheTTLTimeUnit()).build();
        }
        if (memoryPolicy.getExpireAfterAccess() == -1L) {
            return CacheBuilder.newBuilder().maximumSize(memoryPolicy.getMaxSize()).expireAfterWrite(memoryPolicy.getExpireAfterWrite(), memoryPolicy.getExpireAfterTimeUnit()).build();
        }
        return CacheBuilder.newBuilder().maximumSize(memoryPolicy.getMaxSize()).expireAfterAccess(memoryPolicy.getExpireAfterAccess(), memoryPolicy.getExpireAfterTimeUnit()).build();
    }

    static <Key, Parsed> Cache<Key, Observable<Parsed>> createInflighter(MemoryPolicy memoryPolicy) {
        long maximumInFlightRequestsDuration;
        long expireAfterToSeconds = memoryPolicy == null ? StoreDefaults.getCacheTTLTimeUnit().toSeconds(StoreDefaults.getCacheTTL()) : memoryPolicy.getExpireAfterTimeUnit().toSeconds(memoryPolicy.getExpireAfterWrite());
        if (expireAfterToSeconds > (maximumInFlightRequestsDuration = TimeUnit.MINUTES.toSeconds(1L))) {
            return CacheBuilder.newBuilder().expireAfterWrite(maximumInFlightRequestsDuration, TimeUnit.SECONDS).build();
        }
        long expireAfter = memoryPolicy == null ? StoreDefaults.getCacheTTL() : memoryPolicy.getExpireAfterWrite();
        TimeUnit expireAfterUnit = memoryPolicy == null ? StoreDefaults.getCacheTTLTimeUnit() : memoryPolicy.getExpireAfterTimeUnit();
        return CacheBuilder.newBuilder().expireAfterWrite(expireAfter, expireAfterUnit).build();
    }
}

