/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.store.base.DiskRead;
import com.nytimes.android.external.store.base.DiskWrite;
import com.nytimes.android.external.store.base.Fetcher;
import com.nytimes.android.external.store.base.Parser;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.Store;
import com.nytimes.android.external.store.base.impl.BarCode;
import com.nytimes.android.external.store.base.impl.MultiParser;
import com.nytimes.android.external.store.base.impl.RealInternalStore;
import com.nytimes.android.external.store.base.impl.RealStore;
import com.nytimes.android.external.store.util.NoopPersister;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import rx.Observable;
import rx.functions.Func1;

public class ParsingStoreBuilder<Raw, Parsed> {
    private final List<Parser> parsers = new ArrayList<Parser>();
    private Fetcher<Raw> fetcher;
    private Persister<Raw> persister;
    private Cache<BarCode, Observable<Parsed>> memCache;

    @NotNull
    public ParsingStoreBuilder<Raw, Parsed> fetcher(@NotNull Fetcher<Raw> fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @NotNull
    public ParsingStoreBuilder<Raw, Parsed> nonObservableFetcher(final @NotNull Func1<BarCode, Raw> fetcher) {
        this.fetcher = new Fetcher<Raw>(){

            @Override
            @NotNull
            public Observable<Raw> fetch(final BarCode barCode) {
                return Observable.fromCallable((Callable)new Callable<Raw>(){

                    @Override
                    public Raw call() throws Exception {
                        return fetcher.call((Object)barCode);
                    }
                });
            }
        };
        return this;
    }

    @NotNull
    public ParsingStoreBuilder<Raw, Parsed> persister(@NotNull Persister<Raw> persister) {
        this.persister = persister;
        return this;
    }

    @NotNull
    public ParsingStoreBuilder<Raw, Parsed> persister(final @NotNull DiskRead<Raw> diskRead, final @NotNull DiskWrite<Raw> diskWrite) {
        this.persister = new Persister<Raw>(){

            @Override
            @NotNull
            public Observable<Raw> read(BarCode barCode) {
                return diskRead.read(barCode);
            }

            @Override
            @NotNull
            public Observable<Boolean> write(BarCode barCode, Raw raw) {
                return diskWrite.write(barCode, raw);
            }
        };
        return this;
    }

    @NotNull
    public ParsingStoreBuilder<Raw, Parsed> parser(@NotNull Func1<Raw, Parsed> parser) {
        this.parsers.clear();
        this.parsers.add((Parser)parser);
        return this;
    }

    @NotNull
    public ParsingStoreBuilder<Raw, Parsed> parser(@NotNull Parser<Raw, Parsed> parser) {
        this.parsers.clear();
        this.parsers.add(parser);
        return this;
    }

    @NotNull
    public ParsingStoreBuilder<Raw, Parsed> parsers(@NotNull List<Parser> parsers) {
        this.parsers.clear();
        this.parsers.addAll(parsers);
        return this;
    }

    @NotNull
    public static <Raw, Parsed> ParsingStoreBuilder<Raw, Parsed> builder() {
        return new ParsingStoreBuilder<Raw, Parsed>();
    }

    @NotNull
    public ParsingStoreBuilder<Raw, Parsed> memory(Cache<BarCode, Observable<Parsed>> memCache) {
        this.memCache = memCache;
        return this;
    }

    @NotNull
    public Store<Parsed> open() {
        if (this.persister == null) {
            this.persister = new NoopPersister();
        }
        MultiParser multiParser = new MultiParser(this.parsers);
        RealInternalStore realInternalStore = this.memCache == null ? new RealInternalStore(this.fetcher, this.persister, multiParser) : new RealInternalStore(this.fetcher, this.persister, multiParser, this.memCache);
        return new RealStore(realInternalStore);
    }
}

