/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.store.base.Parser;
import com.nytimes.android.external.store.util.ParserException;
import java.util.ArrayList;
import java.util.List;

public class MultiParser<Raw, Parsed>
implements Parser<Raw, Parsed> {
    private final List<Parser> parsers = new ArrayList<Parser>();

    public MultiParser(List<Parser> parsers) {
        Preconditions.checkNotNull(parsers, (String)"Parsers can't be null.");
        Preconditions.checkArgument((!parsers.isEmpty() ? 1 : 0) != 0, (Object)"Parsers can't be empty.");
        for (Parser parser : parsers) {
            Preconditions.checkNotNull((Object)parser, (String)"Parser can't be null.");
        }
        this.parsers.addAll(parsers);
    }

    public Parsed call(Raw raw) {
        Object parsed = raw;
        for (Parser parser : this.parsers) {
            try {
                parsed = parser.call(parsed);
            }
            catch (ClassCastException exception) {
                throw this.createParserException();
            }
        }
        return (Parsed)parsed;
    }

    private ParserException createParserException() {
        return new ParserException("One of the provided parsers has a wrong typing. Make sure that parsers are passed in a correct order and the types match each other.");
    }
}

