/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.middleware;

import com.google.gson.Gson;
import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.store.base.Parser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import okio.BufferedSource;

public class GsonSourceParser<Parsed>
implements Parser<BufferedSource, Parsed> {
    private final Gson gson;
    private final Type type;

    @Inject
    public GsonSourceParser(Gson gson, Type type) {
        Preconditions.checkNotNull((Object)gson, (String)"Gson can't be null");
        Preconditions.checkNotNull((Object)type, (String)"Type can't be null");
        this.gson = gson;
        this.type = type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Parsed call(@Nonnull BufferedSource source) {
        try {
            InputStreamReader reader = new InputStreamReader(source.inputStream(), Charset.forName("UTF-8"));
            Throwable throwable = null;
            try {
                Object object = this.gson.fromJson((Reader)reader, this.type);
                return (Parsed)object;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

