/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.middleware.moshi;

import com.nytimes.android.external.store3.base.Parser;
import com.nytimes.android.external.store3.middleware.moshi.MoshiSourceParser;
import com.nytimes.android.external.store3.middleware.moshi.MoshiStringParser;
import com.squareup.moshi.Moshi;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import okio.BufferedSource;

public final class MoshiParserFactory {
    private MoshiParserFactory() {
    }

    @Nonnull
    public static <T> Parser<String, T> createStringParser(@Nonnull Moshi moshi, @Nonnull Type type) {
        if (moshi == null) {
            throw new NullPointerException("moshi cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null.");
        }
        return new MoshiStringParser(moshi, type);
    }

    @Nonnull
    public static <T> Parser<String, T> createStringParser(@Nonnull Class<T> type) {
        return MoshiParserFactory.createStringParser(new Moshi.Builder().build(), type);
    }

    @Nonnull
    public static <T> Parser<BufferedSource, T> createSourceParser(@Nonnull Moshi moshi, @Nonnull Type type) {
        if (moshi == null) {
            throw new NullPointerException("moshi cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null.");
        }
        return new MoshiSourceParser(moshi, type);
    }

    @Nonnull
    public static <T> Parser<BufferedSource, T> createSourceParser(@Nonnull Type type) {
        return MoshiParserFactory.createSourceParser(new Moshi.Builder().build(), type);
    }
}

