/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.middleware.moshi;

import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.store.base.Parser;
import com.nytimes.android.external.store.middleware.moshi.MoshiSourceParser;
import com.nytimes.android.external.store.middleware.moshi.MoshiStringParser;
import com.squareup.moshi.Moshi;
import java.lang.reflect.Type;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

public final class MoshiParserFactory {
    private MoshiParserFactory() {
    }

    @NotNull
    public static <T> Parser<String, T> createStringParser(@NotNull Moshi moshi, @NotNull Type type) {
        Preconditions.checkNotNull((Object)moshi, (String)"moshi cannot be null.");
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null.");
        return new MoshiStringParser(moshi, type);
    }

    @NotNull
    public static <T> Parser<String, T> createStringParser(@NotNull Class<T> type) {
        return MoshiParserFactory.createStringParser(new Moshi.Builder().build(), type);
    }

    @NotNull
    public static <T> Parser<BufferedSource, T> createSourceParser(@NotNull Moshi moshi, @NotNull Type type) {
        Preconditions.checkNotNull((Object)moshi, (String)"moshi cannot be null.");
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null.");
        return new MoshiSourceParser(moshi, type);
    }

    @NotNull
    public static <T> Parser<BufferedSource, T> createSourceParser(@NotNull Type type) {
        return MoshiParserFactory.createSourceParser(new Moshi.Builder().build(), type);
    }
}

