/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs3;

import com.nytimes.android.external.fs3.RecordPersister;
import com.nytimes.android.external.fs3.SourceAllPersister;
import com.nytimes.android.external.fs3.SourcePersister;
import com.nytimes.android.external.fs3.filesystem.FileSystem;
import com.nytimes.android.external.fs3.filesystem.FileSystemFactory;
import com.nytimes.android.external.store3.base.Persister;
import com.nytimes.android.external.store3.base.impl.BarCode;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import okio.BufferedSource;

public final class SourcePersisterFactory {
    private SourcePersisterFactory() {
    }

    @Nonnull
    public static Persister<BufferedSource, BarCode> create(@Nonnull File root, long expirationDuration, @Nonnull TimeUnit expirationUnit) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException("root file cannot be null.");
        }
        return RecordPersister.create(FileSystemFactory.create(root), expirationDuration, expirationUnit);
    }

    @Nonnull
    public static Persister<BufferedSource, BarCode> create(@Nonnull FileSystem fileSystem, long expirationDuration, @Nonnull TimeUnit expirationUnit) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("fileSystem cannot be null.");
        }
        return RecordPersister.create(fileSystem, expirationDuration, expirationUnit);
    }

    @Nonnull
    public static Persister<BufferedSource, BarCode> create(@Nonnull File root) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException("root file cannot be null.");
        }
        return SourcePersister.create(FileSystemFactory.create(root));
    }

    @Nonnull
    public static Persister<BufferedSource, BarCode> create(@Nonnull FileSystem fileSystem) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("fileSystem cannot be null.");
        }
        return SourcePersister.create(fileSystem);
    }

    @Nonnull
    public static Persister<BufferedSource, BarCode> createAll(@Nonnull File root) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException("root file cannot be null.");
        }
        return SourceAllPersister.create(FileSystemFactory.create(root));
    }

    @Nonnull
    public static Persister<BufferedSource, BarCode> createAll(@Nonnull FileSystem fileSystem) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("fileSystem cannot be null.");
        }
        return SourceAllPersister.create(fileSystem);
    }
}

