/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs3;

import com.nytimes.android.external.fs3.FileSystemPersister;
import com.nytimes.android.external.fs3.FileSystemRecordPersister;
import com.nytimes.android.external.fs3.PathResolver;
import com.nytimes.android.external.fs3.filesystem.FileSystem;
import com.nytimes.android.external.fs3.filesystem.FileSystemFactory;
import com.nytimes.android.external.store3.base.Persister;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import okio.BufferedSource;

public final class FileSystemPersisterFactory {
    private FileSystemPersisterFactory() {
    }

    @Nonnull
    public static <Key> Persister<BufferedSource, Key> create(@Nonnull File root, PathResolver<Key> pathResolver) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException("root file cannot be null.");
        }
        return FileSystemPersister.create(FileSystemFactory.create(root), pathResolver);
    }

    @Nonnull
    public static <Key> Persister<BufferedSource, Key> create(@Nonnull FileSystem fileSystem, PathResolver<Key> pathResolver) throws IOException {
        if (fileSystem == null) {
            throw new IllegalArgumentException("root file cannot be null.");
        }
        return FileSystemPersister.create(fileSystem, pathResolver);
    }

    @Nonnull
    public static <Key> Persister<BufferedSource, Key> create(@Nonnull File root, PathResolver<Key> pathResolver, long expirationDuration, @Nonnull TimeUnit expirationUnit) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException("root file cannot be null.");
        }
        return FileSystemRecordPersister.create(FileSystemFactory.create(root), pathResolver, expirationDuration, expirationUnit);
    }

    @Nonnull
    public static <Key> Persister<BufferedSource, Key> create(@Nonnull FileSystem fileSystem, PathResolver<Key> pathResolver, long expirationDuration, @Nonnull TimeUnit expirationUnit) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("fileSystem cannot be null.");
        }
        return FileSystemRecordPersister.create(fileSystem, pathResolver, expirationDuration, expirationUnit);
    }
}

