/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs;

import com.nytimes.android.external.fs.PathResolver;
import com.nytimes.android.external.fs.filesystem.FileSystem;
import com.nytimes.android.external.store.base.DiskRead;
import java.io.FileNotFoundException;
import javax.annotation.Nonnull;
import okio.BufferedSource;
import rx.Emitter;
import rx.Observable;
import rx.functions.Action1;

public class FSReader<T>
implements DiskRead<BufferedSource, T> {
    final FileSystem fileSystem;
    final PathResolver<T> pathResolver;

    public FSReader(FileSystem fileSystem, PathResolver<T> pathResolver) {
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
    }

    @Nonnull
    public Observable<BufferedSource> read(final @Nonnull T key) {
        return Observable.fromEmitter((Action1)new Action1<Emitter<BufferedSource>>(){

            public void call(Emitter<BufferedSource> emitter) {
                String resolvedKey = FSReader.this.pathResolver.resolve(key);
                boolean exists = FSReader.this.fileSystem.exists(resolvedKey);
                if (exists) {
                    try {
                        BufferedSource bufferedSource = FSReader.this.fileSystem.read(resolvedKey);
                        emitter.onNext((Object)bufferedSource);
                        emitter.onCompleted();
                    }
                    catch (FileNotFoundException e) {
                        emitter.onError((Throwable)e);
                    }
                } else {
                    emitter.onCompleted();
                }
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.NONE);
    }
}

