/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.cache;

import com.nytimes.android.external.cache.Objects;
import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.cache.RemovalCause;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemovalNotification<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private final V value;
    @Nullable
    private final RemovalCause cause;

    @NotNull
    public static <K, V> RemovalNotification<K, V> create(K key, V value, @NotNull RemovalCause cause) {
        return new RemovalNotification<K, V>(key, value, cause);
    }

    private RemovalNotification(K key, V value, @NotNull RemovalCause cause) {
        this.key = key;
        this.value = value;
        this.cause = Preconditions.checkNotNull(cause);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public final V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return Objects.equal(this.getKey(), that.getKey()) && Objects.equal(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        K k = this.getKey();
        V v = this.getValue();
        return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
    }

    @NotNull
    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }
}

