/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.cache;

import com.nytimes.android.external.cache.Function;
import com.nytimes.android.external.cache.Futures;
import com.nytimes.android.external.cache.ListenableFuture;
import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.cache.Supplier;
import java.io.Serializable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheLoader<K, V> {
    protected CacheLoader() {
    }

    @Nullable
    public abstract V load(K var1) throws Exception;

    @Nullable
    public ListenableFuture<V> reload(@NotNull K key, @NotNull V oldValue) throws Exception {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(oldValue);
        return Futures.immediateFuture(this.load(key));
    }

    @NotNull
    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        throw new UnsupportedLoadingOperationException();
    }

    @NotNull
    public static <K, V> CacheLoader<K, V> from(@NotNull Function<K, V> function) {
        return new FunctionToCacheLoader<K, V>(function);
    }

    @NotNull
    public static <V> CacheLoader<Object, V> from(@NotNull Supplier<V> supplier) {
        return new SupplierToCacheLoader<V>(supplier);
    }

    public static final class InvalidCacheLoadException
    extends RuntimeException {
        public InvalidCacheLoadException(String message) {
            super(message);
        }
    }

    public static final class UnsupportedLoadingOperationException
    extends UnsupportedOperationException {
        UnsupportedLoadingOperationException() {
        }
    }

    private static final class SupplierToCacheLoader<V>
    extends CacheLoader<Object, V>
    implements Serializable {
        private final Supplier<V> computingSupplier;
        private static final long serialVersionUID = 0L;

        public SupplierToCacheLoader(@NotNull Supplier<V> computingSupplier) {
            this.computingSupplier = Preconditions.checkNotNull(computingSupplier);
        }

        @Override
        @NotNull
        public V load(@NotNull Object key) {
            Preconditions.checkNotNull(key);
            return this.computingSupplier.get();
        }
    }

    private static final class FunctionToCacheLoader<K, V>
    extends CacheLoader<K, V>
    implements Serializable {
        private final Function<K, V> computingFunction;
        private static final long serialVersionUID = 0L;

        public FunctionToCacheLoader(@NotNull Function<K, V> computingFunction) {
            this.computingFunction = Preconditions.checkNotNull(computingFunction);
        }

        @Override
        @Nullable
        public V load(@NotNull K key) {
            return this.computingFunction.apply(Preconditions.checkNotNull(key));
        }
    }
}

