/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authn.IdpMetadata;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIdentityProvider
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(SamlIdentityProvider.class);
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    private String createdBy = null;
    @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$")
    @Size(min=3, max=2000)
    @JsonProperty(value="idpMetadataUrl")
    public @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$") @Size(min=3, max=2000) String idpMetadataUrl = null;
    @Size(min=3)
    @JsonProperty(value="idpMetadataXml")
    public @Size(min=3) String idpMetadataXml = null;
    @JsonProperty(value="idpMetadata")
    public IdpMetadata idpMetadata = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="name")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String name = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=256)
    @JsonProperty(value="usernameAttribute")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=256) String usernameAttribute = "name";
    @Size(min=3, max=256)
    @JsonProperty(value="emailAttribute")
    public @Size(min=3, max=256) String emailAttribute = "email";
    @Size(min=3, max=256)
    @JsonProperty(value="groupsAttribute")
    public @Size(min=3, max=256) String groupsAttribute = null;
    @Size(min=1, max=3)
    @JsonProperty(value="groupsDelim")
    public @Size(min=1, max=3) String groupsDelim = null;
    @Size(min=0, max=25)
    @JsonProperty(value="customAttributes")
    public @Size(min=0, max=25) List<String> customAttributes = null;
    @Size(min=3, max=2000)
    @JsonProperty(value="entityIssuer")
    public @Size(min=3, max=2000) String entityIssuer = null;
    @JsonProperty(value="isSignedAuthnReqEnabled")
    public Boolean isSignedAuthnReqEnabled = null;

    public SamlIdentityProvider() {
    }

    public SamlIdentityProvider(String tenantId, String extId, List<ApiLink> links, String idpMetadataUrl, String idpMetadataXml, IdpMetadata idpMetadata, String name, String usernameAttribute, String emailAttribute, String groupsAttribute, String groupsDelim, List<String> customAttributes, String entityIssuer, Boolean isSignedAuthnReqEnabled, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, String createdBy) {
        super(tenantId, extId, links);
        this.setIdpMetadataUrl(idpMetadataUrl);
        this.setIdpMetadataXml(idpMetadataXml);
        this.setIdpMetadata(idpMetadata);
        this.setName(name);
        this.setUsernameAttribute(usernameAttribute);
        this.setEmailAttribute(emailAttribute);
        this.setGroupsAttribute(groupsAttribute);
        this.setGroupsDelim(groupsDelim);
        this.setCustomAttributes(customAttributes);
        this.setEntityIssuer(entityIssuer);
        this.setIsSignedAuthnReqEnabled(isSignedAuthnReqEnabled);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setCreatedBy(createdBy);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authn.SamlIdentityProvider";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public static SamlIdentityProviderBuilder SamlIdentityProviderBuilder() {
        return new SamlIdentityProviderBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SamlIdentityProvider)) {
            return false;
        }
        SamlIdentityProvider other = (SamlIdentityProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$idpMetadataUrl = this.getIdpMetadataUrl();
        String other$idpMetadataUrl = other.getIdpMetadataUrl();
        if (this$idpMetadataUrl == null ? other$idpMetadataUrl != null : !this$idpMetadataUrl.equals(other$idpMetadataUrl)) {
            return false;
        }
        String this$idpMetadataXml = this.getIdpMetadataXml();
        String other$idpMetadataXml = other.getIdpMetadataXml();
        if (this$idpMetadataXml == null ? other$idpMetadataXml != null : !this$idpMetadataXml.equals(other$idpMetadataXml)) {
            return false;
        }
        IdpMetadata this$idpMetadata = this.getIdpMetadata();
        IdpMetadata other$idpMetadata = other.getIdpMetadata();
        if (this$idpMetadata == null ? other$idpMetadata != null : !((Object)this$idpMetadata).equals(other$idpMetadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$usernameAttribute = this.getUsernameAttribute();
        String other$usernameAttribute = other.getUsernameAttribute();
        if (this$usernameAttribute == null ? other$usernameAttribute != null : !this$usernameAttribute.equals(other$usernameAttribute)) {
            return false;
        }
        String this$emailAttribute = this.getEmailAttribute();
        String other$emailAttribute = other.getEmailAttribute();
        if (this$emailAttribute == null ? other$emailAttribute != null : !this$emailAttribute.equals(other$emailAttribute)) {
            return false;
        }
        String this$groupsAttribute = this.getGroupsAttribute();
        String other$groupsAttribute = other.getGroupsAttribute();
        if (this$groupsAttribute == null ? other$groupsAttribute != null : !this$groupsAttribute.equals(other$groupsAttribute)) {
            return false;
        }
        String this$groupsDelim = this.getGroupsDelim();
        String other$groupsDelim = other.getGroupsDelim();
        if (this$groupsDelim == null ? other$groupsDelim != null : !this$groupsDelim.equals(other$groupsDelim)) {
            return false;
        }
        List<String> this$customAttributes = this.getCustomAttributes();
        List<String> other$customAttributes = other.getCustomAttributes();
        if (this$customAttributes == null ? other$customAttributes != null : !((Object)this$customAttributes).equals(other$customAttributes)) {
            return false;
        }
        String this$entityIssuer = this.getEntityIssuer();
        String other$entityIssuer = other.getEntityIssuer();
        if (this$entityIssuer == null ? other$entityIssuer != null : !this$entityIssuer.equals(other$entityIssuer)) {
            return false;
        }
        Boolean this$isSignedAuthnReqEnabled = this.getIsSignedAuthnReqEnabled();
        Boolean other$isSignedAuthnReqEnabled = other.getIsSignedAuthnReqEnabled();
        return !(this$isSignedAuthnReqEnabled == null ? other$isSignedAuthnReqEnabled != null : !((Object)this$isSignedAuthnReqEnabled).equals(other$isSignedAuthnReqEnabled));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SamlIdentityProvider;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $idpMetadataUrl = this.getIdpMetadataUrl();
        result = result * 59 + ($idpMetadataUrl == null ? 43 : $idpMetadataUrl.hashCode());
        String $idpMetadataXml = this.getIdpMetadataXml();
        result = result * 59 + ($idpMetadataXml == null ? 43 : $idpMetadataXml.hashCode());
        IdpMetadata $idpMetadata = this.getIdpMetadata();
        result = result * 59 + ($idpMetadata == null ? 43 : ((Object)$idpMetadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $usernameAttribute = this.getUsernameAttribute();
        result = result * 59 + ($usernameAttribute == null ? 43 : $usernameAttribute.hashCode());
        String $emailAttribute = this.getEmailAttribute();
        result = result * 59 + ($emailAttribute == null ? 43 : $emailAttribute.hashCode());
        String $groupsAttribute = this.getGroupsAttribute();
        result = result * 59 + ($groupsAttribute == null ? 43 : $groupsAttribute.hashCode());
        String $groupsDelim = this.getGroupsDelim();
        result = result * 59 + ($groupsDelim == null ? 43 : $groupsDelim.hashCode());
        List<String> $customAttributes = this.getCustomAttributes();
        result = result * 59 + ($customAttributes == null ? 43 : ((Object)$customAttributes).hashCode());
        String $entityIssuer = this.getEntityIssuer();
        result = result * 59 + ($entityIssuer == null ? 43 : $entityIssuer.hashCode());
        Boolean $isSignedAuthnReqEnabled = this.getIsSignedAuthnReqEnabled();
        result = result * 59 + ($isSignedAuthnReqEnabled == null ? 43 : ((Object)$isSignedAuthnReqEnabled).hashCode());
        return result;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getIdpMetadataUrl() {
        return this.idpMetadataUrl;
    }

    public String getIdpMetadataXml() {
        return this.idpMetadataXml;
    }

    public IdpMetadata getIdpMetadata() {
        return this.idpMetadata;
    }

    public String getName() {
        return this.name;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public String getGroupsAttribute() {
        return this.groupsAttribute;
    }

    public String getGroupsDelim() {
        return this.groupsDelim;
    }

    public List<String> getCustomAttributes() {
        return this.customAttributes;
    }

    public String getEntityIssuer() {
        return this.entityIssuer;
    }

    public Boolean getIsSignedAuthnReqEnabled() {
        return this.isSignedAuthnReqEnabled;
    }

    @JsonProperty(value="idpMetadataUrl")
    public void setIdpMetadataUrl(String idpMetadataUrl) {
        this.idpMetadataUrl = idpMetadataUrl;
    }

    @JsonProperty(value="idpMetadataXml")
    public void setIdpMetadataXml(String idpMetadataXml) {
        this.idpMetadataXml = idpMetadataXml;
    }

    @JsonProperty(value="idpMetadata")
    public void setIdpMetadata(IdpMetadata idpMetadata) {
        this.idpMetadata = idpMetadata;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="usernameAttribute")
    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    @JsonProperty(value="emailAttribute")
    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    @JsonProperty(value="groupsAttribute")
    public void setGroupsAttribute(String groupsAttribute) {
        this.groupsAttribute = groupsAttribute;
    }

    @JsonProperty(value="groupsDelim")
    public void setGroupsDelim(String groupsDelim) {
        this.groupsDelim = groupsDelim;
    }

    @JsonProperty(value="customAttributes")
    public void setCustomAttributes(List<String> customAttributes) {
        this.customAttributes = customAttributes;
    }

    @JsonProperty(value="entityIssuer")
    public void setEntityIssuer(String entityIssuer) {
        this.entityIssuer = entityIssuer;
    }

    @JsonProperty(value="isSignedAuthnReqEnabled")
    public void setIsSignedAuthnReqEnabled(Boolean isSignedAuthnReqEnabled) {
        this.isSignedAuthnReqEnabled = isSignedAuthnReqEnabled;
    }

    @Override
    public String toString() {
        return "SamlIdentityProvider(createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdBy=" + this.getCreatedBy() + ", idpMetadataUrl=" + this.getIdpMetadataUrl() + ", idpMetadataXml=" + this.getIdpMetadataXml() + ", idpMetadata=" + this.getIdpMetadata() + ", name=" + this.getName() + ", usernameAttribute=" + this.getUsernameAttribute() + ", emailAttribute=" + this.getEmailAttribute() + ", groupsAttribute=" + this.getGroupsAttribute() + ", groupsDelim=" + this.getGroupsDelim() + ", customAttributes=" + this.getCustomAttributes() + ", entityIssuer=" + this.getEntityIssuer() + ", isSignedAuthnReqEnabled=" + this.getIsSignedAuthnReqEnabled() + ")";
    }

    public static class SamlIdentityProviderBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String idpMetadataUrl;
        private String idpMetadataXml;
        private IdpMetadata idpMetadata;
        private String name;
        private String usernameAttribute;
        private String emailAttribute;
        private String groupsAttribute;
        private String groupsDelim;
        private List<String> customAttributes;
        private String entityIssuer;
        private Boolean isSignedAuthnReqEnabled;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private String createdBy;

        SamlIdentityProviderBuilder() {
        }

        public SamlIdentityProviderBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SamlIdentityProviderBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public SamlIdentityProviderBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public SamlIdentityProviderBuilder idpMetadataUrl(String idpMetadataUrl) {
            this.idpMetadataUrl = idpMetadataUrl;
            return this;
        }

        public SamlIdentityProviderBuilder idpMetadataXml(String idpMetadataXml) {
            this.idpMetadataXml = idpMetadataXml;
            return this;
        }

        public SamlIdentityProviderBuilder idpMetadata(IdpMetadata idpMetadata) {
            this.idpMetadata = idpMetadata;
            return this;
        }

        public SamlIdentityProviderBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SamlIdentityProviderBuilder usernameAttribute(String usernameAttribute) {
            this.usernameAttribute = usernameAttribute;
            return this;
        }

        public SamlIdentityProviderBuilder emailAttribute(String emailAttribute) {
            this.emailAttribute = emailAttribute;
            return this;
        }

        public SamlIdentityProviderBuilder groupsAttribute(String groupsAttribute) {
            this.groupsAttribute = groupsAttribute;
            return this;
        }

        public SamlIdentityProviderBuilder groupsDelim(String groupsDelim) {
            this.groupsDelim = groupsDelim;
            return this;
        }

        public SamlIdentityProviderBuilder customAttributes(List<String> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public SamlIdentityProviderBuilder entityIssuer(String entityIssuer) {
            this.entityIssuer = entityIssuer;
            return this;
        }

        public SamlIdentityProviderBuilder isSignedAuthnReqEnabled(Boolean isSignedAuthnReqEnabled) {
            this.isSignedAuthnReqEnabled = isSignedAuthnReqEnabled;
            return this;
        }

        public SamlIdentityProviderBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public SamlIdentityProviderBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public SamlIdentityProviderBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public SamlIdentityProvider build() {
            return new SamlIdentityProvider(this.tenantId, this.extId, this.links, this.idpMetadataUrl, this.idpMetadataXml, this.idpMetadata, this.name, this.usernameAttribute, this.emailAttribute, this.groupsAttribute, this.groupsDelim, this.customAttributes, this.entityIssuer, this.isSignedAuthnReqEnabled, this.createdTime, this.lastUpdatedTime, this.createdBy);
        }

        public String toString() {
            return "SamlIdentityProvider.SamlIdentityProviderBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", idpMetadataUrl=" + this.idpMetadataUrl + ", idpMetadataXml=" + this.idpMetadataXml + ", idpMetadata=" + this.idpMetadata + ", name=" + this.name + ", usernameAttribute=" + this.usernameAttribute + ", emailAttribute=" + this.emailAttribute + ", groupsAttribute=" + this.groupsAttribute + ", groupsDelim=" + this.groupsDelim + ", customAttributes=" + this.customAttributes + ", entityIssuer=" + this.entityIssuer + ", isSignedAuthnReqEnabled=" + this.isSignedAuthnReqEnabled + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdBy=" + this.createdBy + ")";
        }
    }
}

