/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.util.MiscUtils;

public final class AsyncHttpClientConfigDefaults {
    public static final String ASYNC_CLIENT = AsyncHttpClientConfig.class.getName() + ".";

    private AsyncHttpClientConfigDefaults() {
    }

    public static int defaultMaxConnections() {
        return Integer.getInteger(ASYNC_CLIENT + "maxConnections", -1);
    }

    public static int defaultMaxConnectionsPerHost() {
        return Integer.getInteger(ASYNC_CLIENT + "maxConnectionsPerHost", -1);
    }

    public static int defaultConnectionTimeout() {
        return Integer.getInteger(ASYNC_CLIENT + "connectionTimeout", 60000);
    }

    public static int defaultPooledConnectionIdleTimeout() {
        return Integer.getInteger(ASYNC_CLIENT + "pooledConnectionIdleTimeout", 60000);
    }

    public static int defaultReadTimeout() {
        return Integer.getInteger(ASYNC_CLIENT + "readTimeout", 60000);
    }

    public static int defaultRequestTimeout() {
        return Integer.getInteger(ASYNC_CLIENT + "requestTimeout", 60000);
    }

    public static int defaultWebSocketTimeout() {
        return Integer.getInteger(ASYNC_CLIENT + "webSocketTimeout", 900000);
    }

    public static int defaultConnectionTTL() {
        return Integer.getInteger(ASYNC_CLIENT + "connectionTTL", -1);
    }

    public static boolean defaultFollowRedirect() {
        return Boolean.getBoolean(ASYNC_CLIENT + "followRedirect");
    }

    public static int defaultMaxRedirects() {
        return Integer.getInteger(ASYNC_CLIENT + "maxRedirects", 5);
    }

    public static boolean defaultCompressionEnabled() {
        return Boolean.getBoolean(ASYNC_CLIENT + "compressionEnabled");
    }

    public static String defaultUserAgent() {
        return System.getProperty(ASYNC_CLIENT + "userAgent", "AHC/1.0");
    }

    public static int defaultIoThreadMultiplier() {
        return Integer.getInteger(ASYNC_CLIENT + "ioThreadMultiplier", 2);
    }

    public static boolean defaultUseProxySelector() {
        return Boolean.getBoolean(ASYNC_CLIENT + "useProxySelector");
    }

    public static boolean defaultUseProxyProperties() {
        return Boolean.getBoolean(ASYNC_CLIENT + "useProxyProperties");
    }

    public static boolean defaultStrict302Handling() {
        return Boolean.getBoolean(ASYNC_CLIENT + "strict302Handling");
    }

    public static boolean defaultAllowPoolingConnections() {
        return MiscUtils.getBoolean(ASYNC_CLIENT + "allowPoolingConnections", true);
    }

    public static boolean defaultUseRelativeURIsWithConnectProxies() {
        return MiscUtils.getBoolean(ASYNC_CLIENT + "useRelativeURIsWithConnectProxies", true);
    }

    public static int defaultMaxRequestRetry() {
        return Integer.getInteger(ASYNC_CLIENT + "maxRequestRetry", 5);
    }

    public static boolean defaultAllowPoolingSslConnections() {
        return MiscUtils.getBoolean(ASYNC_CLIENT + "allowPoolingSslConnections", true);
    }

    public static boolean defaultDisableUrlEncodingForBoundRequests() {
        return Boolean.getBoolean(ASYNC_CLIENT + "disableUrlEncodingForBoundRequests");
    }

    public static boolean defaultRemoveQueryParamOnRedirect() {
        return MiscUtils.getBoolean(ASYNC_CLIENT + "removeQueryParamOnRedirect", true);
    }

    public static boolean defaultAcceptAnyCertificate() {
        return MiscUtils.getBoolean(ASYNC_CLIENT + "acceptAnyCertificate", false);
    }
}

