/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ByteArrayPart;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseBodyPartsInputStream;
import com.ning.http.client.Param;
import com.ning.http.client.Part;
import com.ning.http.client.Request;
import com.ning.http.client.uri.UriComponents;
import com.ning.http.multipart.ByteArrayPartSource;
import com.ning.http.multipart.FilePart;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.multipart.StringPart;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpProviderUtils {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    static final byte[] EMPTY_BYTE_ARRAY = "".getBytes();

    public static final void validateSupportedScheme(UriComponents uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("ws") && !scheme.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + uri + ", must be equal (ignoring case) to 'http', 'https', 'ws', or 'wss'");
        }
    }

    public static final String getBaseUrl(UriComponents uri) {
        return uri.getScheme() + "://" + AsyncHttpProviderUtils.getAuthority(uri);
    }

    public static final String getAuthority(UriComponents uri) {
        int port = uri.getPort() != -1 ? uri.getPort() : AsyncHttpProviderUtils.getDefaultPort(uri);
        return uri.getHost() + ":" + port;
    }

    public static final String contentToString(List<HttpResponseBodyPart> bodyParts, String charset) throws UnsupportedEncodingException {
        return new String(AsyncHttpProviderUtils.contentToByte(bodyParts), charset);
    }

    public static final byte[] contentToByte(List<HttpResponseBodyPart> bodyParts) throws UnsupportedEncodingException {
        if (bodyParts.size() == 1) {
            return bodyParts.get(0).getBodyPartBytes();
        }
        int size = 0;
        for (HttpResponseBodyPart body : bodyParts) {
            size += body.getBodyPartBytes().length;
        }
        byte[] bytes = new byte[size];
        int offset = 0;
        for (HttpResponseBodyPart body : bodyParts) {
            byte[] bodyBytes = body.getBodyPartBytes();
            System.arraycopy(bodyBytes, 0, bytes, offset, bodyBytes.length);
            offset += bodyBytes.length;
        }
        return bytes;
    }

    public static final InputStream contentToInputStream(List<HttpResponseBodyPart> bodyParts) throws UnsupportedEncodingException {
        return bodyParts.isEmpty() ? new ByteArrayInputStream(EMPTY_BYTE_ARRAY) : new HttpResponseBodyPartsInputStream(bodyParts);
    }

    public static final int getDefaultPort(UriComponents uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().equals("http") || uri.getScheme().equals("ws") ? 80 : 443;
        }
        return port;
    }

    public static final String getNonEmptyPath(UriComponents uri) {
        return MiscUtils.isNonEmpty(uri.getPath()) ? uri.getPath() : "/";
    }

    public static final MultipartRequestEntity createMultipartRequestEntity(List<Part> params, FluentCaseInsensitiveStringsMap requestHeaders) throws FileNotFoundException {
        com.ning.http.multipart.Part[] parts = new com.ning.http.multipart.Part[params.size()];
        int i = 0;
        for (Part part : params) {
            if (part instanceof com.ning.http.multipart.Part) {
                parts[i] = (com.ning.http.multipart.Part)part;
            } else if (part instanceof com.ning.http.client.StringPart) {
                com.ning.http.client.StringPart stringPart = (com.ning.http.client.StringPart)part;
                parts[i] = new StringPart(part.getName(), stringPart.getValue(), stringPart.getCharset());
            } else if (part instanceof com.ning.http.client.FilePart) {
                com.ning.http.client.FilePart filePart = (com.ning.http.client.FilePart)part;
                parts[i] = new FilePart(part.getName(), filePart.getFile(), filePart.getMimeType(), filePart.getCharSet());
            } else if (part instanceof ByteArrayPart) {
                ByteArrayPart byteArrayPart = (ByteArrayPart)part;
                ByteArrayPartSource source = new ByteArrayPartSource(byteArrayPart.getFileName(), byteArrayPart.getData());
                parts[i] = new FilePart(part.getName(), source, byteArrayPart.getMimeType(), byteArrayPart.getCharSet());
            } else {
                if (part == null) {
                    throw new NullPointerException("Part cannot be null");
                }
                throw new IllegalArgumentException(String.format("Unsupported part type for multipart parameter %s", part.getName()));
            }
            ++i;
        }
        return new MultipartRequestEntity(parts, requestHeaders);
    }

    public static final byte[] readFully(InputStream in, int[] lengthWrapper) throws IOException {
        int left;
        int count;
        byte[] b = new byte[Math.max(512, in.available())];
        int offset = 0;
        while ((count = in.read(b, offset, left = b.length - offset)) >= 0) {
            offset += count;
            if (count != left) continue;
            b = AsyncHttpProviderUtils.doubleUp(b);
        }
        lengthWrapper[0] = offset;
        return b;
    }

    private static byte[] doubleUp(byte[] b) {
        int len = b.length;
        byte[] b2 = new byte[len + len];
        System.arraycopy(b, 0, b2, 0, len);
        return b2;
    }

    public static String constructUserAgent(Class<? extends AsyncHttpProvider> httpProvider) {
        StringBuilder b = new StringBuilder("AsyncHttpClient/1.0").append(" ").append("(").append(httpProvider.getSimpleName()).append(" - ").append(System.getProperty("os.name")).append(" - ").append(System.getProperty("os.version")).append(" - ").append(System.getProperty("java.version")).append(" - ").append(Runtime.getRuntime().availableProcessors()).append(" core(s))");
        return b.toString();
    }

    public static String parseCharset(String contentType) {
        for (String part : contentType.split(";")) {
            String[] val;
            if (!part.trim().startsWith("charset=") || (val = part.split("=")).length <= 1) continue;
            String charset = val[1].trim();
            return charset.replaceAll("\"", "").replaceAll("'", "");
        }
        return null;
    }

    public static String keepAliveHeaderValue(AsyncHttpClientConfig config) {
        return config.isAllowPoolingConnections() ? "keep-alive" : "close";
    }

    public static int requestTimeout(AsyncHttpClientConfig config, Request request) {
        return request.getRequestTimeout() != 0 ? request.getRequestTimeout() : config.getRequestTimeout();
    }

    public static boolean followRedirect(AsyncHttpClientConfig config, Request request) {
        return request.getFollowRedirect() != null ? request.getFollowRedirect().booleanValue() : config.isFollowRedirect();
    }

    public static String formParams2UTF8String(List<Param> params) {
        StringBuilder sb = new StringBuilder(params.size() * 15);
        for (Param param : params) {
            UTF8UrlEncoder.appendEncoded(sb, param.getName());
            sb.append("=");
            UTF8UrlEncoder.appendEncoded(sb, param.getValue());
            sb.append("&");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

