/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ConnectionPoolPartitioning;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.Param;
import com.ning.http.client.PerHostConnectionPoolPartioning;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.SignatureCalculator;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.QueryComputer;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestBuilderBase<T extends RequestBuilderBase<T>> {
    private static final Logger logger = LoggerFactory.getLogger(RequestBuilderBase.class);
    private static final Uri DEFAULT_REQUEST_URL = Uri.create("http://localhost");
    private final Class<T> derived;
    protected final RequestImpl request;
    protected QueryComputer queryComputer;
    protected List<Param> queryParams;
    protected SignatureCalculator signatureCalculator;

    protected RequestBuilderBase(Class<T> derived, String method, boolean disableUrlEncoding) {
        this(derived, method, QueryComputer.queryComputer(disableUrlEncoding));
    }

    protected RequestBuilderBase(Class<T> derived, String method, QueryComputer queryComputer) {
        this.derived = derived;
        this.request = new RequestImpl();
        this.request.method = method;
        this.queryComputer = queryComputer;
    }

    protected RequestBuilderBase(Class<T> derived, Request prototype) {
        this(derived, prototype, QueryComputer.URL_ENCODING_ENABLED_QUERY_COMPUTER);
    }

    protected RequestBuilderBase(Class<T> derived, Request prototype, QueryComputer queryComputer) {
        this.derived = derived;
        this.request = new RequestImpl(prototype);
        this.queryComputer = queryComputer;
    }

    public T setUrl(String url) {
        return this.setUri(Uri.create(url));
    }

    public T setUri(Uri uri) {
        this.request.uri = uri;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setInetAddress(InetAddress address) {
        this.request.address = address;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setLocalInetAddress(InetAddress address) {
        this.request.localAddress = address;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setVirtualHost(String virtualHost) {
        this.request.virtualHost = virtualHost;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeader(String name, String value) {
        this.request.headers.replaceWith(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addHeader(String name, String value) {
        if (value == null) {
            logger.warn("Value was null, set to \"\"");
            value = "";
        }
        this.request.headers.add(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeaders(FluentCaseInsensitiveStringsMap headers) {
        this.request.headers = headers == null ? new FluentCaseInsensitiveStringsMap() : new FluentCaseInsensitiveStringsMap(headers);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeaders(Map<String, Collection<String>> headers) {
        this.request.headers = headers == null ? new FluentCaseInsensitiveStringsMap() : new FluentCaseInsensitiveStringsMap(headers);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setContentLength(int length) {
        this.request.length = length;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    private void lazyInitCookies() {
        if (this.request.cookies == null) {
            this.request.cookies = new ArrayList(3);
        }
    }

    public T setCookies(Collection<Cookie> cookies) {
        this.request.cookies = new ArrayList<Cookie>(cookies);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addCookie(Cookie cookie) {
        this.lazyInitCookies();
        this.request.cookies.add(cookie);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addOrReplaceCookie(Cookie cookie) {
        String cookieKey = cookie.getName();
        boolean replace = false;
        int index = 0;
        this.lazyInitCookies();
        for (Cookie c : this.request.cookies) {
            if (c.getName().equals(cookieKey)) {
                replace = true;
                break;
            }
            ++index;
        }
        if (replace) {
            this.request.cookies.set(index, cookie);
        } else {
            this.request.cookies.add(cookie);
        }
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public void resetCookies() {
        if (this.request.cookies != null) {
            this.request.cookies.clear();
        }
    }

    public void resetQuery() {
        this.queryParams = null;
        this.request.uri = this.request.uri.withNewQuery(null);
    }

    public void resetFormParams() {
        this.request.formParams = null;
    }

    public void resetNonMultipartData() {
        RequestImpl.access$902(this.request, null);
        this.request.stringData = null;
        this.request.streamData = null;
        this.request.length = -1L;
    }

    public void resetMultipartData() {
        this.request.parts = null;
    }

    public T setBody(File file) {
        this.request.file = file;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(byte[] data) {
        this.resetFormParams();
        this.resetNonMultipartData();
        this.resetMultipartData();
        RequestImpl.access$902(this.request, data);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(String data) {
        this.resetFormParams();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.stringData = data;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(InputStream stream) {
        this.resetFormParams();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.streamData = stream;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(BodyGenerator bodyGenerator) {
        this.request.bodyGenerator = bodyGenerator;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addQueryParam(String name, String value) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<Param>(1);
        }
        this.queryParams.add(new Param(name, value));
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addQueryParams(List<Param> queryParams) {
        for (Param queryParam : queryParams) {
            this.addQueryParam(queryParam.getName(), queryParam.getValue());
        }
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    private List<Param> map2ParamList(Map<String, List<String>> map) {
        if (map == null) {
            return null;
        }
        ArrayList<Param> params = new ArrayList<Param>(map.size());
        for (Map.Entry<String, List<String>> entries : map.entrySet()) {
            String name = entries.getKey();
            for (String value : entries.getValue()) {
                params.add(new Param(name, value));
            }
        }
        return params;
    }

    public T setQueryParams(Map<String, List<String>> map) {
        return this.setQueryParams(this.map2ParamList(map));
    }

    public T setQueryParams(List<Param> params) {
        this.queryParams = params;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addFormParam(String name, String value) {
        this.resetNonMultipartData();
        this.resetMultipartData();
        if (this.request.formParams == null) {
            this.request.formParams = new ArrayList(1);
        }
        this.request.formParams.add(new Param(name, value));
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setFormParams(Map<String, List<String>> map) {
        return this.setFormParams(this.map2ParamList(map));
    }

    public T setFormParams(List<Param> params) {
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.formParams = params;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addBodyPart(Part part) {
        this.resetFormParams();
        this.resetNonMultipartData();
        if (this.request.parts == null) {
            this.request.parts = new ArrayList();
        }
        this.request.parts.add(part);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setProxyServer(ProxyServer proxyServer) {
        this.request.proxyServer = proxyServer;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setRealm(Realm realm) {
        this.request.realm = realm;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setFollowRedirects(boolean followRedirects) {
        this.request.followRedirects = followRedirects;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setRequestTimeout(int requestTimeout) {
        this.request.requestTimeout = requestTimeout;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setRangeOffset(long rangeOffset) {
        this.request.rangeOffset = rangeOffset;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setMethod(String method) {
        this.request.method = method;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBodyEncoding(String charset) {
        this.request.charset = charset;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setConnectionPoolKeyStrategy(ConnectionPoolPartitioning connectionPoolKeyStrategy) {
        this.request.connectionPoolPartitioning = connectionPoolKeyStrategy;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    private void executeSignatureCalculator() {
        if (this.signatureCalculator != null) {
            this.signatureCalculator.calculateAndAddSignature(this.request, this);
        }
    }

    private void computeRequestCharset() {
        if (this.request.charset == null) {
            try {
                String charset;
                String contentType = this.request.headers.getFirstValue("Content-Type");
                if (contentType != null && (charset = AsyncHttpProviderUtils.parseCharset(contentType)) != null) {
                    this.request.charset = charset;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void computeRequestLength() {
        String contentLength;
        if (this.request.length < 0L && this.request.streamData == null && (contentLength = this.request.headers.getFirstValue("Content-Length")) != null) {
            try {
                this.request.length = Long.parseLong(contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void computeFinalUri() {
        if (this.request.uri == null) {
            logger.debug("setUrl hasn't been invoked. Using {}", (Object)DEFAULT_REQUEST_URL);
            this.request.uri = RequestBuilderBase.DEFAULT_REQUEST_URL;
        }
        AsyncHttpProviderUtils.validateSupportedScheme(this.request.uri);
        String newQuery = this.queryComputer.computeFullQueryString(this.request.uri.getQuery(), this.queryParams);
        this.request.uri = this.request.uri.withNewQuery(newQuery);
    }

    public Request build() {
        this.computeFinalUri();
        this.executeSignatureCalculator();
        this.computeRequestCharset();
        this.computeRequestLength();
        return this.request;
    }

    private static final class RequestImpl
    implements Request {
        private String method;
        private Uri uri;
        private InetAddress address;
        private InetAddress localAddress;
        private FluentCaseInsensitiveStringsMap headers = new FluentCaseInsensitiveStringsMap();
        private ArrayList<Cookie> cookies;
        private byte[] byteData;
        private String stringData;
        private InputStream streamData;
        private BodyGenerator bodyGenerator;
        private List<Param> formParams;
        private List<Part> parts;
        private String virtualHost;
        private long length = -1L;
        public ProxyServer proxyServer;
        private Realm realm;
        private File file;
        private Boolean followRedirects;
        private int requestTimeout;
        private long rangeOffset;
        public String charset;
        private ConnectionPoolPartitioning connectionPoolPartitioning = PerHostConnectionPoolPartioning.INSTANCE;
        private List<Param> queryParams;

        public RequestImpl() {
        }

        public RequestImpl(Request prototype) {
            if (prototype != null) {
                this.method = prototype.getMethod();
                this.uri = prototype.getUri();
                this.address = prototype.getInetAddress();
                this.localAddress = prototype.getLocalAddress();
                this.headers = new FluentCaseInsensitiveStringsMap(prototype.getHeaders());
                this.cookies = new ArrayList<Cookie>(prototype.getCookies());
                this.byteData = prototype.getByteData();
                this.stringData = prototype.getStringData();
                this.streamData = prototype.getStreamData();
                this.bodyGenerator = prototype.getBodyGenerator();
                this.formParams = prototype.getFormParams() == null ? null : new ArrayList<Param>(prototype.getFormParams());
                this.parts = prototype.getParts() == null ? null : new ArrayList<Part>(prototype.getParts());
                this.virtualHost = prototype.getVirtualHost();
                this.length = prototype.getContentLength();
                this.proxyServer = prototype.getProxyServer();
                this.realm = prototype.getRealm();
                this.file = prototype.getFile();
                this.followRedirects = prototype.getFollowRedirect();
                this.requestTimeout = prototype.getRequestTimeout();
                this.rangeOffset = prototype.getRangeOffset();
                this.charset = prototype.getBodyEncoding();
                this.connectionPoolPartitioning = prototype.getConnectionPoolPartitioning();
            }
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        @Override
        public InetAddress getInetAddress() {
            return this.address;
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.localAddress;
        }

        @Override
        public Uri getUri() {
            return this.uri;
        }

        @Override
        public String getUrl() {
            return this.uri.toUrl();
        }

        @Override
        public FluentCaseInsensitiveStringsMap getHeaders() {
            return this.headers;
        }

        @Override
        public Collection<Cookie> getCookies() {
            return this.cookies != null ? Collections.unmodifiableCollection(this.cookies) : Collections.emptyList();
        }

        @Override
        public byte[] getByteData() {
            return this.byteData;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public InputStream getStreamData() {
            return this.streamData;
        }

        @Override
        public BodyGenerator getBodyGenerator() {
            return this.bodyGenerator;
        }

        @Override
        public long getContentLength() {
            return this.length;
        }

        @Override
        public List<Param> getFormParams() {
            return this.formParams != null ? this.formParams : Collections.emptyList();
        }

        @Override
        public List<Part> getParts() {
            return this.parts != null ? this.parts : Collections.emptyList();
        }

        @Override
        public String getVirtualHost() {
            return this.virtualHost;
        }

        @Override
        public ProxyServer getProxyServer() {
            return this.proxyServer;
        }

        @Override
        public Realm getRealm() {
            return this.realm;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public Boolean getFollowRedirect() {
            return this.followRedirects;
        }

        @Override
        public int getRequestTimeout() {
            return this.requestTimeout;
        }

        @Override
        public long getRangeOffset() {
            return this.rangeOffset;
        }

        @Override
        public String getBodyEncoding() {
            return this.charset;
        }

        @Override
        public ConnectionPoolPartitioning getConnectionPoolPartitioning() {
            return this.connectionPoolPartitioning;
        }

        @Override
        public List<Param> getQueryParams() {
            if (this.queryParams == null) {
                if (MiscUtils.isNonEmpty(this.uri.getQuery())) {
                    this.queryParams = new ArrayList<Param>(1);
                    for (String queryStringParam : this.uri.getQuery().split("&")) {
                        int pos = queryStringParam.indexOf(61);
                        if (pos <= 0) {
                            this.queryParams.add(new Param(queryStringParam, null));
                            continue;
                        }
                        this.queryParams.add(new Param(queryStringParam.substring(0, pos), queryStringParam.substring(pos + 1)));
                    }
                } else {
                    this.queryParams = Collections.emptyList();
                }
            }
            return this.queryParams;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getUrl());
            sb.append("\t");
            sb.append(this.method);
            sb.append("\theaders:");
            if (MiscUtils.isNonEmpty(this.headers)) {
                for (String name : this.headers.keySet()) {
                    sb.append("\t");
                    sb.append(name);
                    sb.append(":");
                    sb.append(this.headers.getJoinedValue(name, ", "));
                }
            }
            if (MiscUtils.isNonEmpty(this.formParams)) {
                sb.append("\tformParams:");
                for (Param param : this.formParams) {
                    sb.append("\t");
                    sb.append(param.getName());
                    sb.append(":");
                    sb.append(param.getValue());
                }
            }
            return sb.toString();
        }

        static /* synthetic */ byte[] access$902(RequestImpl x0, byte[] x1) {
            x0.byteData = x1;
            return x1;
        }
    }
}

