/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.uri.UriComponents;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.Base64;
import com.ning.http.util.MiscUtils;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public final class AuthenticatorUtils {
    public static String computeBasicAuthentication(Realm realm) throws UnsupportedEncodingException {
        String s = realm.getPrincipal() + ":" + realm.getPassword();
        return "Basic " + Base64.encode(s.getBytes(realm.getEncoding()));
    }

    public static String computeBasicAuthentication(ProxyServer proxyServer) throws UnsupportedEncodingException {
        String s = proxyServer.getPrincipal() + ":" + proxyServer.getPassword();
        return "Basic " + Base64.encode(s.getBytes(proxyServer.getEncoding()));
    }

    private static String computeRealmURI(Realm realm) {
        boolean omitQuery;
        UriComponents uri = realm.getUri();
        if (realm.isTargetProxy()) {
            return "/";
        }
        boolean bl = omitQuery = realm.isOmitQuery() && MiscUtils.isNonEmpty(uri.getQuery());
        if (realm.isUseAbsoluteURI()) {
            return omitQuery ? uri.withNewQuery(null).toUrl() : uri.toUrl();
        }
        String path = AsyncHttpProviderUtils.getNonEmptyPath(uri);
        return omitQuery ? path : path + "?" + uri.getQuery();
    }

    public static String computeDigestAuthentication(Realm realm) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.construct(builder, "username", realm.getPrincipal());
        AuthenticatorUtils.construct(builder, "realm", realm.getRealmName());
        AuthenticatorUtils.construct(builder, "nonce", realm.getNonce());
        AuthenticatorUtils.construct(builder, "uri", AuthenticatorUtils.computeRealmURI(realm));
        builder.append("algorithm").append('=').append(realm.getAlgorithm()).append(", ");
        AuthenticatorUtils.construct(builder, "response", realm.getResponse());
        if (MiscUtils.isNonEmpty(realm.getOpaque())) {
            AuthenticatorUtils.construct(builder, "opaque", realm.getOpaque());
        }
        builder.append("qop").append('=').append(realm.getQop()).append(", ");
        builder.append("nc").append('=').append(realm.getNc()).append(", ");
        AuthenticatorUtils.construct(builder, "cnonce", realm.getCnonce(), true);
        return new String(builder.toString().getBytes("ISO-8859-1"));
    }

    private static StringBuilder construct(StringBuilder builder, String name, String value) {
        return AuthenticatorUtils.construct(builder, name, value, false);
    }

    private static StringBuilder construct(StringBuilder builder, String name, String value, boolean tail) {
        return builder.append(name).append('=').append('\"').append(value).append(tail ? "\"" : "\", ");
    }
}

