/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.util;

import com.nineoldandroids.util.NoSuchPropertyException;
import com.nineoldandroids.util.Property;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ReflectiveProperty<T, V>
extends Property<T, V> {
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_IS = "is";
    private static final String PREFIX_SET = "set";
    private Method mSetter;
    private Method mGetter;
    private Field mField;

    public ReflectiveProperty(Class<T> propertyHolder, Class<V> valueType, String name) {
        super(valueType, name);
        char firstLetter = Character.toUpperCase(name.charAt(0));
        String theRest = name.substring(1);
        String capitalizedName = firstLetter + theRest;
        String getterName = PREFIX_GET + capitalizedName;
        try {
            this.mGetter = propertyHolder.getMethod(getterName, null);
        }
        catch (NoSuchMethodException e) {
            try {
                this.mGetter = propertyHolder.getDeclaredMethod(getterName, null);
                this.mGetter.setAccessible(true);
            }
            catch (NoSuchMethodException e2) {
                getterName = PREFIX_IS + capitalizedName;
                try {
                    this.mGetter = propertyHolder.getMethod(getterName, null);
                }
                catch (NoSuchMethodException e3) {
                    try {
                        this.mGetter = propertyHolder.getDeclaredMethod(getterName, null);
                        this.mGetter.setAccessible(true);
                    }
                    catch (NoSuchMethodException e4) {
                        try {
                            this.mField = propertyHolder.getField(name);
                            Class<?> fieldType = this.mField.getType();
                            if (!this.typesMatch(valueType, fieldType)) {
                                throw new NoSuchPropertyException("Underlying type (" + fieldType + ") " + "does not match Property type (" + valueType + ")");
                            }
                            return;
                        }
                        catch (NoSuchFieldException e5) {
                            throw new NoSuchPropertyException("No accessor method or field found for property with name " + name);
                        }
                    }
                }
            }
        }
        Class<?> getterType = this.mGetter.getReturnType();
        if (!this.typesMatch(valueType, getterType)) {
            throw new NoSuchPropertyException("Underlying type (" + getterType + ") " + "does not match Property type (" + valueType + ")");
        }
        String setterName = PREFIX_SET + capitalizedName;
        try {
            this.mSetter = propertyHolder.getDeclaredMethod(setterName, getterType);
            this.mSetter.setAccessible(true);
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
    }

    private boolean typesMatch(Class<V> valueType, Class getterType) {
        if (getterType != valueType) {
            if (getterType.isPrimitive()) {
                return getterType == Float.TYPE && valueType == Float.class || getterType == Integer.TYPE && valueType == Integer.class || getterType == Boolean.TYPE && valueType == Boolean.class || getterType == Long.TYPE && valueType == Long.class || getterType == Double.TYPE && valueType == Double.class || getterType == Short.TYPE && valueType == Short.class || getterType == Byte.TYPE && valueType == Byte.class || getterType == Character.TYPE && valueType == Character.class;
            }
            return false;
        }
        return true;
    }

    @Override
    public void set(T object, V value) {
        if (this.mSetter != null) {
            try {
                this.mSetter.invoke(object, value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        } else if (this.mField != null) {
            try {
                this.mField.set(object, value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        } else {
            throw new UnsupportedOperationException("Property " + this.getName() + " is read-only");
        }
    }

    @Override
    public V get(T object) {
        if (this.mGetter != null) {
            try {
                return (V)this.mGetter.invoke(object, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        if (this.mField != null) {
            try {
                return (V)this.mField.get(object);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean isReadOnly() {
        return this.mSetter == null && this.mField == null;
    }
}

