/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.identification;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import com.nhnent.owl.android.feed.encrypt.Hash;
import com.nhnent.owl.android.feed.identification.AdvertisingIdProvider;
import java.util.UUID;

public final class DeviceIdentifier {
    private static final String TAG = "Feed." + DeviceIdentifier.class.getSimpleName();
    private static final String ANDROID_ID_BUG_MSG = "The device suffers from the Android ID bug - its ID is the emulator ID : 9774d56d682e549c";
    private static volatile String androidId;
    private static volatile String md5hash;
    protected static volatile String deviceId;
    private static volatile String adId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getDeviceIdentifier(Context context, boolean ignoreBuggyAndroidID) throws DeviceIDException {
        String result = null;
        if (result != null) return result;
        Class<DeviceIdentifier> clazz = DeviceIdentifier.class;
        synchronized (DeviceIdentifier.class) {
            block5: {
                result = deviceId;
                if (result != null) return result;
                try {
                    androidId = DeviceIdentifier.getAndroidId(context);
                    Log.d((String)TAG, (String)("androidId : " + androidId));
                    md5hash = Hash.computeHashMD5(androidId);
                    Log.d((String)TAG, (String)("md5hash : " + md5hash));
                    UUID uuid = UUID.nameUUIDFromBytes(md5hash.getBytes("utf8"));
                    result = deviceId = uuid.toString();
                    Log.d((String)TAG, (String)("deviceId : " + deviceId));
                }
                catch (Exception e) {
                    if (ignoreBuggyAndroidID) break block5;
                    throw new DeviceIDException(e);
                }
            }
            if (result == null) throw new DeviceIDException();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public static synchronized String getAndroidId(Context ctx) throws DeviceIDException {
        return IDs.ANDROID_ID.getId(ctx);
    }

    public static synchronized String getPseudoDeviceId(Context ctx) {
        String pseudoId = null;
        try {
            pseudoId = IDs.PSEUDO_ID.getId(ctx);
            Log.d((String)TAG, (String)("getPseudoDeviceId -  pseudoId : " + pseudoId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pseudoId;
    }

    public static final class DeviceIDNotUniqueException
    extends DeviceIDException {
        private static final long serialVersionUID = -8940090896069484955L;

        public DeviceIDNotUniqueException() {
            super(DeviceIdentifier.ANDROID_ID_BUG_MSG);
        }
    }

    public static class DeviceIDException
    extends Exception {
        private static final long serialVersionUID = -8083699995384519417L;
        private static final String NO_ANDROID_ID = "Could not retrieve a device ID";

        public DeviceIDException(Throwable throwable) {
            super(NO_ANDROID_ID, throwable);
        }

        public DeviceIDException(String detailMessage) {
            super(detailMessage);
        }

        public DeviceIDException() {
            super(NO_ANDROID_ID);
        }
    }

    private static enum IDs {
        ANDROID_ID{

            @Override
            String getId(Context context) throws DeviceIDException {
                String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                if (IDs.BUGGY_ANDROID_ID.equals(androidId)) {
                    Log.w((String)TAG, (String)DeviceIdentifier.ANDROID_ID_BUG_MSG);
                    throw new DeviceIDNotUniqueException();
                }
                return androidId;
            }
        }
        ,
        ADVERTISING_ID{

            @Override
            String getId(Context context) throws DeviceIDException {
                AdvertisingIdProvider.getAdvertisingId(context, new AdvertisingIdProvider.Listener(){

                    @Override
                    public void onAdvertisingIdClientFinish(AdvertisingIdProvider.AdInfo adInfo) {
                        adId = adInfo.getId();
                    }

                    @Override
                    public void onAdvertisingIdClientFail(Exception exception) {
                        Log.e((String)"Feed", (String)exception.getMessage());
                    }
                });
                return adId;
            }
        }
        ,
        PSEUDO_ID{

            @Override
            String getId(Context context) throws DeviceIDException {
                String devIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10;
                devIDShort = Build.VERSION.SDK_INT >= 21 ? devIDShort + Build.SUPPORTED_ABIS[0].length() % 10 : devIDShort + Build.CPU_ABI.length() % 10;
                devIDShort = devIDShort + (Build.DEVICE.length() % 10 + (Build.DISPLAY.length() % 10 + Build.HOST.length() % 10) + (Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10) + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + (Build.TAGS.length() % 10 + Build.TYPE.length() % 10) + Build.USER.length() % 10);
                try {
                    String serial = Build.class.getField("SERIAL").get(null).toString();
                    return new UUID(devIDShort.hashCode(), serial.hashCode()).toString();
                }
                catch (Exception e) {
                    String serial = "ESYDV000";
                    return new UUID(devIDShort.hashCode(), serial.hashCode()).toString();
                }
            }
        };

        private static final String TAG;
        static final String BUGGY_ANDROID_ID = "9774d56d682e549c";

        abstract String getId(Context var1) throws DeviceIDException;

        static {
            TAG = "Feed" + IDs.class.getSimpleName();
        }
    }
}

