/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.encrypt;

import android.util.Base64;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSACipher {
    private static final String CIPHER_MODE = "RSA/ECB/PKCS1Padding";
    private static final String ALGORITHM = "RSA";

    public static PublicKey getPublicKey(String pubkey) {
        try {
            byte[] buffer = Base64.decode((String)pubkey, (int)0);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PrivateKey getPrivateKey(String privateKey) {
        try {
            byte[] buffer = Base64.decode((String)privateKey, (int)0);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptWithBase64(byte[] plainText, PublicKey publicKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(1, publicKey);
            byte[] output = cipher.doFinal(plainText);
            return Base64.encodeToString((byte[])output, (int)2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decrypt(byte[] cipherText, PrivateKey privateKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(2, privateKey);
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

