/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.encrypt;

import android.util.Base64;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCipher {
    private static final String CIPHER_MODE = "AES/CBC/PKCS5Padding";
    private static final String ALGORITHM = "AES";

    public static String encryptWithBase64(byte[] plainText, byte[] secretKey, byte[] initVector) {
        try {
            IvParameterSpec iv = new IvParameterSpec(initVector);
            SecretKeySpec skeySpec = new SecretKeySpec(secretKey, ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(1, (Key)skeySpec, iv);
            return Base64.encodeToString((byte[])cipher.doFinal(plainText), (int)2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decrypt(byte[] cipherText, byte[] secretKey, byte[] initVector) {
        try {
            IvParameterSpec iv = new IvParameterSpec(Base64.decode((byte[])initVector, (int)0));
            SecretKeySpec skeySpec = new SecretKeySpec(secretKey, ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(2, (Key)skeySpec, iv);
            byte[] original = cipher.doFinal(Base64.decode((byte[])cipherText, (int)0));
            return original;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] generateAESKey() {
        byte[] aesKey = null;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
            keyGenerator.init(256);
            aesKey = keyGenerator.generateKey().getEncoded();
            return aesKey;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return aesKey;
        }
    }

    public static byte[] getIV() {
        byte[] ivData = new byte[16];
        SecureRandom random = new SecureRandom();
        random.nextBytes(ivData);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(ivData);
        return ivParameterSpec.getIV();
    }
}

