/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.data.utils;

import android.content.Context;
import android.os.Build;
import android.os.Debug;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class EmulatorUtil {
    private final Context context;

    public EmulatorUtil(Context context) {
        this.context = context;
    }

    private static boolean hasEth0Interface() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                if (!intf.getName().equals("eth0")) continue;
                return true;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return false;
    }

    private static boolean hasQemuCpuInfo() {
        try {
            String line;
            BufferedReader cpuInfoReader = new BufferedReader(new FileReader("/proc/cpuinfo"));
            while ((line = cpuInfoReader.readLine()) != null) {
                if (!line.contains("Goldfish")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean hasQemuFile() {
        return new File("/init.goldfish.rc").exists() || new File("/sys/qemu_trace").exists() || new File("/system/bin/qemud").exists();
    }

    private static String getProp(Context ctx, String propName) {
        try {
            ClassLoader cl = ctx.getClassLoader();
            Class<?> klazz = cl.loadClass("android.os.properties");
            Method getProp = klazz.getMethod("get", String.class);
            Object[] params = new Object[]{propName};
            return (String)getProp.invoke(klazz, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private boolean hasQemuBuildProps() {
        return "goldfish".equals(EmulatorUtil.getProp(this.context, "ro.hardware")) || "ranchu".equals(EmulatorUtil.getProp(this.context, "ro.hardware")) || "generic".equals(EmulatorUtil.getProp(this.context, "ro.product.device")) || "1".equals(EmulatorUtil.getProp(this.context, "ro.kernel.qemu")) || "0".equals(EmulatorUtil.getProp(this.context, "ro.secure"));
    }

    private boolean isDebuggerConnected() {
        return Debug.isDebuggerConnected();
    }

    private boolean hasEmulatorBuildProp() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || Build.PRODUCT.contains("google_sdk") || Build.PRODUCT.contains("sdk") || Build.HARDWARE.contains("goldfish") || Build.HARDWARE.contains("ranchu") || Build.BOARD.contains("unknown") || Build.ID.contains("FRF91") || Build.MANUFACTURER.contains("unknown") || Build.SERIAL == null || Build.TAGS.contains("test-keys");
    }

    private boolean hasEmulatorTelephonyProperty() {
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_PHONE_STATE") == -1) {
            return false;
        }
        TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
        if (tm != null) {
            String voiceMailNumber;
            String deviceId;
            String networkOperator;
            String subscriberId;
            String phoneNumber = tm.getLine1Number();
            if (phoneNumber == null || phoneNumber.length() == 0) {
                phoneNumber = "unknown";
            }
            if ((subscriberId = tm.getSubscriberId()) == null || subscriberId.length() == 0) {
                subscriberId = "unknown";
            }
            if ((networkOperator = tm.getNetworkOperatorName()) == null || networkOperator.length() == 0) {
                networkOperator = "unknown";
            }
            if ((deviceId = tm.getDeviceId()) == null || deviceId.length() == 0) {
                deviceId = "unknown";
            }
            if ((voiceMailNumber = tm.getVoiceMailNumber()) == null || voiceMailNumber.length() == 0) {
                voiceMailNumber = "unknown";
            }
            return "Android".equals(networkOperator) || "Android".equals(tm.getSimOperator()) || "000000000000000".equals(deviceId) || deviceId.matches("^0+$") || phoneNumber.startsWith("155552155") || subscriberId.endsWith("0000000000") || "15552175049".equals(voiceMailNumber);
        }
        return false;
    }

    public boolean isEmulator() {
        return this.hasEmulatorTelephonyProperty() || this.hasEmulatorBuildProp() || EmulatorUtil.hasQemuCpuInfo() || EmulatorUtil.hasQemuFile() || EmulatorUtil.hasEth0Interface();
    }
}

