/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.data.properties.sources;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nhnent.owl.android.feed.data.properties.BaseProperties;
import com.nhnent.owl.android.feed.data.properties.Retriever;

public class TelephoneProperties
extends BaseProperties {
    private _telephone telephone = new _telephone();
    TelephonyManager tm = (TelephonyManager)this.ctx.getSystemService("phone");

    public TelephoneProperties(@NonNull Context context) {
        super(context);
    }

    @Override
    public void reset() {
    }

    @Override
    public void retrieve(Retriever.PropertyCallback callback) {
        int phoneType = this.tm.getPhoneType();
        switch (phoneType) {
            case 1: {
                this.telephone.phone_type = "gsm";
                break;
            }
            case 2: {
                this.telephone.phone_type = "cdma";
                break;
            }
            case 3: {
                this.telephone.phone_type = "sip";
                break;
            }
            default: {
                this.telephone.phone_type = "none";
            }
        }
        int radioType = this.tm.getNetworkType();
        switch (radioType) {
            case 1: {
                this.telephone.radio_type = "gprs";
                break;
            }
            case 2: {
                this.telephone.radio_type = "edge";
                break;
            }
            case 3: {
                this.telephone.radio_type = "umts";
                break;
            }
            case 4: {
                this.telephone.radio_type = "cdma";
                break;
            }
            case 5: {
                this.telephone.radio_type = "evdo_0";
                break;
            }
            case 6: {
                this.telephone.radio_type = "evdo_a";
                break;
            }
            case 7: {
                this.telephone.radio_type = "1xrtt";
                break;
            }
            case 8: {
                this.telephone.radio_type = "hsdpa";
                break;
            }
            case 9: {
                this.telephone.radio_type = "hsupa";
                break;
            }
            case 10: {
                this.telephone.radio_type = "hspa";
                break;
            }
            case 11: {
                this.telephone.radio_type = "iden";
                break;
            }
            case 12: {
                this.telephone.radio_type = "evdo_b";
                break;
            }
            case 13: {
                this.telephone.radio_type = "lte";
                break;
            }
            case 14: {
                this.telephone.radio_type = "ehrpd";
                break;
            }
            case 15: {
                this.telephone.radio_type = "hspap";
                break;
            }
            case 16: {
                this.telephone.radio_type = "gsm";
                break;
            }
            default: {
                this.telephone.radio_type = "none";
            }
        }
        String networkOperator = this.tm.getNetworkOperator();
        if (networkOperator == null || networkOperator.length() == 0) {
            this.telephone.mcc = "unknown";
            this.telephone.mnc = "unknown";
        } else {
            this.telephone.mcc = networkOperator.substring(0, 3);
            this.telephone.mnc = networkOperator.substring(3);
        }
        this.telephone.sim_country_iso = this.tm.getSimCountryIso();
        this.telephone.network_country_iso = this.tm.getNetworkCountryIso();
        this.telephone.network_operator_name = this.tm.getNetworkOperatorName();
        if (this.tm.getSimState() == 5) {
            this.telephone.sim_operator = this.tm.getSimOperator();
            this.telephone.sim_operator_name = this.tm.getSimOperatorName();
        }
        if (this.ctx.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
            this.telephone.phone_number = this.tm.getLine1Number();
            this.telephone.imei = this.tm.getDeviceId();
            this.telephone.imsi = this.tm.getSubscriberId();
            this.telephone.sim_serial = this.tm.getSimSerialNumber();
            this.telephone.voice_mail = this.tm.getVoiceMailNumber();
        }
        callback.onComplete(this.telephone);
    }

    @Override
    public void checkUnGrantedPermission() {
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.READ_PHONE_STATE") != 0) {
            this.ungrantedPermissions.add("android.permission.READ_PHONE_STATE");
        }
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        String json = gson.toJson((Object)this.telephone);
        return json;
    }

    public class _telephone {
        private String phone_type;
        private String radio_type;
        private String mcc;
        private String mnc;
        private String sim_country_iso;
        private String network_country_iso;
        private String network_operator_name;
        private String sim_operator;
        private String sim_operator_name;
        private String phone_number;
        private String imei;
        private String imsi;
        private String sim_serial;
        private String voice_mail;

        public String getPhone_type() {
            if (this.phone_type == null || this.phone_type.length() == 0) {
                return "";
            }
            return this.phone_type;
        }

        public String getRadio_type() {
            if (this.radio_type == null || this.radio_type.length() == 0) {
                return "";
            }
            return this.radio_type;
        }

        public String getMcc() {
            if (this.mcc == null || this.mcc.length() == 0) {
                return "";
            }
            return this.mcc;
        }

        public String getMnc() {
            if (this.mnc == null || this.mnc.length() == 0) {
                return "";
            }
            return this.mnc;
        }

        public String getSim_country_iso() {
            if (this.sim_country_iso == null || this.sim_country_iso.length() == 0) {
                return "";
            }
            return this.sim_country_iso;
        }

        public String getNetwork_country_iso() {
            if (this.network_country_iso == null || this.network_country_iso.length() == 0) {
                return "";
            }
            return this.network_country_iso;
        }

        public String getNetwork_operator_name() {
            if (this.network_operator_name == null || this.network_operator_name.length() == 0) {
                return "";
            }
            return this.network_operator_name;
        }

        public String getSim_operator() {
            if (this.sim_operator == null || this.sim_operator.length() == 0) {
                return "";
            }
            return this.sim_operator;
        }

        public String getSim_operator_name() {
            if (this.sim_operator_name == null || this.sim_operator_name.length() == 0) {
                return "";
            }
            return this.sim_operator_name;
        }

        public String getPhone_number() {
            if (this.phone_number == null || this.phone_number.length() == 0) {
                return "";
            }
            return this.phone_number;
        }

        public String getImei() {
            if (this.imei == null || this.imei.length() == 0) {
                return "";
            }
            return this.imei;
        }

        public String getImsi() {
            if (this.imsi == null || this.imsi.length() == 0) {
                return "";
            }
            return this.imsi;
        }

        public String getSim_serial() {
            if (this.sim_serial == null || this.sim_serial.length() == 0) {
                return "";
            }
            return this.sim_serial;
        }

        public String getVoice_mail() {
            if (this.voice_mail == null || this.voice_mail.length() == 0) {
                return "";
            }
            return this.voice_mail;
        }
    }
}

