/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.data.properties.sources;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nhnent.owl.android.feed.data.properties.BaseProperties;
import com.nhnent.owl.android.feed.data.properties.Retriever;
import com.nhnent.owl.android.feed.data.utils.CommonUtil;
import com.nhnent.owl.android.feed.data.utils.DeviceUtil;
import java.util.ArrayList;
import java.util.List;

public class NetworkProperties
extends BaseProperties {
    private static final String TAG = "Feed." + NetworkProperties.class.getSimpleName();
    private _network network = new _network();

    public NetworkProperties(@NonNull Context context) {
        super(context);
    }

    @Override
    public void reset() {
    }

    @Override
    public void retrieve(Retriever.PropertyCallback callback) {
        if (Build.VERSION.SDK_INT < 14) {
            this.network.proxy = Proxy.getHost((Context)this.ctx) + ":" + Proxy.getPort((Context)this.ctx);
        } else {
            this.network.proxy = System.getProperty("http.proxyHost") + ":" + System.getProperty("http.proxyPort");
        }
        WifiManager wifiManager = (WifiManager)this.ctx.getSystemService("wifi");
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.INTERNET") == 0) {
            this.network.wifi_mac = DeviceUtil.getWifiMacAddress();
            this.network.cell_ip = DeviceUtil.getLocalIpAddress();
        } else {
            WifiInfo wifiInfo;
            Log.w((String)TAG, (String)"android.permission.INTERNET  denied");
            if (wifiManager != null && ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_WIFI_STATE") == 0 && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
                this.network.wifi_mac = wifiInfo.getMacAddress();
                this.network.cell_ip = CommonUtil.formatIpInt(wifiInfo.getIpAddress());
            }
        }
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_WIFI_STATE") == 0) {
            List wifiConfigurations;
            List scanResults;
            DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
            if (dhcpInfo != null) {
                this.network.gateway = CommonUtil.formatIpInt(dhcpInfo.gateway);
                this.network.netmask = CommonUtil.formatIpInt(dhcpInfo.netmask);
                this.network.dhcp = CommonUtil.formatIpInt(dhcpInfo.serverAddress);
                this.network.dns = CommonUtil.formatIpInt(dhcpInfo.dns1);
            } else {
                Log.w((String)TAG, (String)"getDhcpInfo return null");
            }
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            if (wifiInfo != null) {
                this.network.ssid = wifiInfo.getSSID().replace("\"", "");
                this.network.wifi_ip = CommonUtil.formatIpInt(wifiInfo.getIpAddress());
                this.network.bssid = wifiInfo.getBSSID();
                this.network.rssi = String.valueOf(wifiInfo.getRssi());
            } else {
                Log.w((String)TAG, (String)"no wifi connect");
            }
            if ((ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 || ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) && (scanResults = wifiManager.getScanResults()) != null) {
                ArrayList<String> scanSSIDs = new ArrayList<String>();
                for (ScanResult scanResult : scanResults) {
                    if (scanResult.SSID.length() <= 0) continue;
                    scanSSIDs.add(scanResult.SSID);
                }
                this.network.scan_ssid = CommonUtil.ListToString(scanSSIDs, ",");
            }
            if ((wifiConfigurations = wifiManager.getConfiguredNetworks()) != null) {
                ArrayList<String> configurationSSIDs = new ArrayList<String>();
                for (WifiConfiguration wifiConfiguration : wifiConfigurations) {
                    configurationSSIDs.add(wifiConfiguration.SSID);
                }
                this.network.configuration_ssid = CommonUtil.ListToString(configurationSSIDs, ",");
            }
        } else {
            Log.w((String)TAG, (String)"android.permission.ACCESS_WIFI_STATE denied");
        }
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_NETWORK_STATE") == 0) {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.ctx.getSystemService("connectivity");
            NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
            if (activeNetwork != null) {
                String type = "unknown";
                switch (activeNetwork.getType()) {
                    case 7: {
                        type = "bluetooth";
                        break;
                    }
                    case 8: {
                        type = "dummy";
                        break;
                    }
                    case 9: {
                        type = "ethernet";
                        break;
                    }
                    case 0: {
                        type = "mobile";
                        break;
                    }
                    case 4: {
                        type = "dun";
                        break;
                    }
                    case 5: {
                        type = "hipri";
                        break;
                    }
                    case 2: {
                        type = "mms";
                        break;
                    }
                    case 3: {
                        type = "supl";
                        break;
                    }
                    case 17: {
                        type = "vpn";
                        break;
                    }
                    case 1: {
                        type = "wifi";
                        break;
                    }
                    case 6: {
                        type = "wimax";
                    }
                }
                this.network.network_type = String.valueOf(type);
            }
        } else {
            Log.w((String)TAG, (String)"android.permission.ACCESS_NETWORK_STATE denied");
        }
        callback.onComplete(this.network);
    }

    @Override
    public void checkUnGrantedPermission() {
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.INTERNET") != 0) {
            this.ungrantedPermissions.add("android.permission.INTERNET");
        }
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_NETWORK_STATE") != 0) {
            this.ungrantedPermissions.add("android.permission.ACCESS_NETWORK_STATE");
        }
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_WIFI_STATE") != 0) {
            this.ungrantedPermissions.add("android.permission.ACCESS_WIFI_STATE");
        }
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        String json = gson.toJson((Object)this.network);
        return json;
    }

    public class _network {
        private String proxy;
        private String wifi_mac;
        private String cell_ip;
        private String gateway;
        private String netmask;
        private String dhcp;
        private String dns;
        private String ssid;
        private String wifi_ip;
        private String bssid;
        private String rssi;
        private String scan_ssid;
        private String configuration_ssid;
        private String network_type;

        public String getProxy() {
            if (this.proxy == null || this.proxy.length() == 0) {
                return "";
            }
            return this.proxy;
        }

        public String getWifi_mac() {
            if (this.wifi_mac == null || this.wifi_mac.length() == 0) {
                return "";
            }
            return this.wifi_mac;
        }

        public String getCell_ip() {
            if (this.cell_ip == null || this.cell_ip.length() == 0) {
                return "";
            }
            return this.cell_ip;
        }

        public String getGateway() {
            if (this.gateway == null || this.gateway.length() == 0) {
                return "";
            }
            return this.gateway;
        }

        public String getNetmask() {
            if (this.netmask == null || this.netmask.length() == 0) {
                return "";
            }
            return this.netmask;
        }

        public String getDhcp() {
            if (this.dhcp == null || this.dhcp.length() == 0) {
                return "";
            }
            return this.dhcp;
        }

        public String getDns() {
            if (this.dns == null || this.dns.length() == 0) {
                return "";
            }
            return this.dns;
        }

        public String getSsid() {
            if (this.ssid == null || this.ssid.length() == 0) {
                return "";
            }
            return this.ssid;
        }

        public String getWifi_ip() {
            if (this.wifi_ip == null || this.wifi_ip.length() == 0) {
                return "";
            }
            return this.wifi_ip;
        }

        public String getBssid() {
            if (this.bssid == null || this.bssid.length() == 0) {
                return "";
            }
            return this.bssid;
        }

        public String getRssi() {
            if (this.rssi == null || this.rssi.length() == 0) {
                return "";
            }
            return this.rssi;
        }

        public String getScan_ssid() {
            if (this.scan_ssid == null || this.scan_ssid.length() == 0) {
                return "";
            }
            return this.scan_ssid;
        }

        public String getConfiguration_ssid() {
            if (this.configuration_ssid == null || this.configuration_ssid.length() == 0) {
                return "";
            }
            return this.configuration_ssid;
        }

        public String getNetwork_type() {
            if (this.network_type == null || this.network_type.length() == 0) {
                return "";
            }
            return this.network_type;
        }
    }
}

