/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.data.properties.sources;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.graphics.Typeface;
import android.os.Build;
import android.os.SystemClock;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nhnent.owl.android.feed.data.properties.BaseProperties;
import com.nhnent.owl.android.feed.data.properties.Retriever;
import com.nhnent.owl.android.feed.data.utils.DeviceUtil;
import com.nhnent.owl.android.feed.data.utils.EmulatorUtil;
import com.nhnent.owl.android.feed.identification.AdvertisingIdProvider;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DeviceProperties
extends BaseProperties {
    private EmulatorUtil emulator;
    private _device device;

    public DeviceProperties(@NonNull Context context) {
        super(context);
        this.emulator = new EmulatorUtil(context);
        this.device = new _device();
    }

    @Override
    public void reset() {
    }

    @Override
    public void retrieve(final Retriever.PropertyCallback callback) {
        this.device.os_version = Build.VERSION.RELEASE;
        this.device.model = Build.MODEL;
        this.device.brand = Build.BRAND;
        this.device.serial = Build.SERIAL;
        this.device.display = Build.DISPLAY;
        this.device.host = Build.HOST;
        this.device.device = Build.DEVICE;
        this.device.hardware = Build.HARDWARE;
        this.device.tags = Build.TAGS;
        this.device.fingerprint = Build.FINGERPRINT;
        this.device.current_time = String.valueOf(System.currentTimeMillis());
        this.device.boot_time = String.valueOf(System.currentTimeMillis() - SystemClock.elapsedRealtime());
        this.device.up_time = String.valueOf(SystemClock.uptimeMillis());
        this.device.active_time = String.valueOf(SystemClock.elapsedRealtime() - SystemClock.uptimeMillis());
        this.device.timezone = TimeZone.getDefault().getDisplayName();
        this.device.language = Locale.getDefault().getLanguage();
        this.device.locale = Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        if (Build.VERSION.SDK_INT >= 14) {
            this.device.base_band_version = Build.getRadioVersion();
        }
        try {
            DisplayMetrics displayMetrics = this.ctx.getResources().getDisplayMetrics();
            this.device.screen_resolution = displayMetrics.widthPixels + "x" + displayMetrics.heightPixels;
            this.device.android_id = Settings.Secure.getString((ContentResolver)this.ctx.getContentResolver(), (String)"android_id");
            this.device.brightness = Settings.System.getString((ContentResolver)this.ctx.getContentResolver(), (String)"screen_brightness");
            this.device.bluetooth_mac = Settings.Secure.getString((ContentResolver)this.ctx.getContentResolver(), (String)"bluetooth_address");
            Date aDate = new Date(System.currentTimeMillis());
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
            calendar.setTime(aDate);
            this.device.client_time = String.format(Locale.getDefault(), "%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
            String system_ua = System.getProperty("http.agent");
            if (Build.VERSION.SDK_INT >= 17) {
                this.device.user_agent = WebSettings.getDefaultUserAgent((Context)this.ctx) + "__" + system_ua;
            } else {
                this.device.user_agent = new WebView(this.ctx).getSettings().getUserAgentString() + "__" + system_ua;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.device.cpu_frequency = String.valueOf(DeviceUtil.getMaxCpuFreq());
        this.device.cpu_type = DeviceUtil.getCpuName();
        this.device.cpu_hardware = DeviceUtil.getCpuHardware();
        this.device.total_memory = String.valueOf(DeviceUtil.getTotalMemoryInMb());
        this.device.available_memory = String.valueOf(DeviceUtil.getFreeMemoryInKb() >> 10);
        this.device.max_heap_size = String.valueOf(DeviceUtil.getMaxHeapSizeInBytes(this.ctx) >> 20);
        this.device.heap_allocation_percent = String.valueOf(DeviceUtil.getHeapAllocatePercent());
        this.device.heap_used_percent = String.valueOf(DeviceUtil.getHeapUsedPercent(this.ctx));
        this.device.total_internal_storage = DeviceUtil.getTotalInternalMemorySize();
        this.device.available_internal_storage = DeviceUtil.getAvailableInternalMemorySize();
        this.device.total_external_storage = DeviceUtil.getTotalExternalMemorySize();
        this.device.available_external_storage = DeviceUtil.getAvailableExternalMemorySize();
        this.device.rooted = String.valueOf(DeviceUtil.isRooted());
        this.device.kernel_version = System.getProperty("os.version");
        this.device.emulator = String.valueOf(this.emulator.isEmulator());
        this.device.font_hash = String.valueOf(Typeface.DEFAULT.hashCode());
        this.device.allow_mock_location = String.valueOf(DeviceUtil.isMockLocationEnabled(this.ctx));
        IntentFilter batteryFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryIntent = this.ctx.registerReceiver(null, batteryFilter);
        if (batteryIntent != null) {
            int batterStatus = batteryIntent.getIntExtra("status", 1);
            switch (batterStatus) {
                case 2: {
                    this.device.battery_status = "charging";
                    break;
                }
                case 3: {
                    this.device.battery_status = "discharging";
                    break;
                }
                case 5: {
                    this.device.battery_status = "full";
                    break;
                }
                case 4: {
                    this.device.battery_status = "not_charging";
                    break;
                }
                default: {
                    this.device.battery_status = "unknown";
                }
            }
        }
        this.device.battery_temperature = Integer.toString(batteryIntent.getIntExtra("temperature", -1));
        this.device.battery_level = Integer.toString(batteryIntent.getIntExtra("level", -1));
        int orientation = this.ctx.getResources().getConfiguration().orientation;
        switch (orientation) {
            case 2: {
                this.device.orientation = "landscape";
                break;
            }
            case 1: {
                this.device.orientation = "portrait";
                break;
            }
            case 0: {
                this.device.orientation = "unknown";
            }
        }
        SharedPreferences prefs = this.ctx.getSharedPreferences("prefs_feed", 0);
        this.device.device_id = prefs.getString("deviceId", null);
        AdvertisingIdProvider.getAdvertisingId(this.ctx, new AdvertisingIdProvider.Listener(){

            @Override
            public void onAdvertisingIdClientFinish(AdvertisingIdProvider.AdInfo adInfo) {
                DeviceProperties.this.device.ad_id = adInfo.getId();
                DeviceProperties.this.device.ad_not_track = String.valueOf(adInfo.isLimitAdTrackingEnabled());
                callback.onComplete(DeviceProperties.this.device);
            }

            @Override
            public void onAdvertisingIdClientFail(Exception exception) {
                Log.w((String)"Feed", (String)exception.getMessage());
                callback.onComplete(DeviceProperties.this.device);
            }
        });
    }

    @Override
    public void checkUnGrantedPermission() {
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        String json = gson.toJson((Object)this.device);
        return json;
    }

    public class _device {
        private String os_version;
        private String model;
        private String brand;
        private String serial;
        private String display;
        private String host;
        private String device;
        private String hardware;
        private String tags;
        private String fingerprint;
        private String client_time;
        private String current_time;
        private String boot_time;
        private String up_time;
        private String active_time;
        private String timezone;
        private String language;
        private String locale;
        private String base_band_version;
        private String screen_resolution;
        private String user_agent;
        private String android_id;
        private String ad_id;
        private String device_id;
        private String ad_not_track;
        private String brightness;
        private String bluetooth_mac;
        private String cpu_frequency;
        private String cpu_type;
        private String cpu_hardware;
        private String total_memory;
        private String available_memory;
        private String max_heap_size;
        private String heap_allocation_percent;
        private String heap_used_percent;
        private String total_internal_storage;
        private String available_internal_storage;
        private String total_external_storage;
        private String available_external_storage;
        private String rooted;
        private String emulator;
        private String orientation;
        private String kernel_version;
        private String font_hash;
        private String allow_mock_location;
        private String battery_status;
        private String battery_level;
        private String battery_temperature;

        public String getOs_version() {
            if (this.os_version == null || this.os_version.length() == 0) {
                return "";
            }
            return this.os_version;
        }

        public String getModel() {
            if (this.model == null || this.model.length() == 0) {
                return "";
            }
            return this.model;
        }

        public String getBrand() {
            if (this.brand == null || this.brand.length() == 0) {
                return "";
            }
            return this.brand;
        }

        public String getSerial() {
            if (this.serial == null || this.serial.length() == 0) {
                return "";
            }
            return this.serial;
        }

        public String getDisplay() {
            if (this.display == null || this.display.length() == 0) {
                return "";
            }
            return this.display;
        }

        public String getHost() {
            if (this.host == null || this.host.length() == 0) {
                return "";
            }
            return this.host;
        }

        public String getDevice() {
            if (this.device == null || this.device.length() == 0) {
                return "";
            }
            return this.device;
        }

        public String getHardware() {
            if (this.hardware == null || this.serial.length() == 0) {
                return "";
            }
            return this.hardware;
        }

        public String getTags() {
            if (this.tags == null || this.serial.length() == 0) {
                return "";
            }
            return this.tags;
        }

        public String getFingerprint() {
            if (this.fingerprint == null || this.fingerprint.length() == 0) {
                return "";
            }
            return this.fingerprint;
        }

        public String getClient_time() {
            if (this.client_time == null || this.client_time.length() == 0) {
                return "";
            }
            return this.client_time;
        }

        public String getCurrent_time() {
            if (this.current_time == null || this.current_time.length() == 0) {
                return "";
            }
            return this.current_time;
        }

        public String getBoot_time() {
            if (this.boot_time == null || this.boot_time.length() == 0) {
                return "";
            }
            return this.boot_time;
        }

        public String getUp_time() {
            if (this.up_time == null || this.up_time.length() == 0) {
                return "";
            }
            return this.up_time;
        }

        public String getActive_time() {
            if (this.active_time == null || this.active_time.length() == 0) {
                return "";
            }
            return this.active_time;
        }

        public String getTimezone() {
            if (this.timezone == null || this.timezone.length() == 0) {
                return "";
            }
            return this.timezone;
        }

        public String getLanguage() {
            if (this.language == null || this.language.length() == 0) {
                return "";
            }
            return this.language;
        }

        public String getLocale() {
            if (this.locale == null || this.locale.length() == 0) {
                return "";
            }
            return this.locale;
        }

        public String getBase_band_version() {
            if (this.base_band_version == null || this.base_band_version.length() == 0) {
                return "";
            }
            return this.base_band_version;
        }

        public String getScreen_resolution() {
            if (this.screen_resolution == null || this.screen_resolution.length() == 0) {
                return "";
            }
            return this.screen_resolution;
        }

        public String getUser_agent() {
            if (this.user_agent == null || this.user_agent.length() == 0) {
                return "";
            }
            return this.user_agent;
        }

        public String getAndroid_id() {
            if (this.android_id == null || this.android_id.length() == 0) {
                return "";
            }
            return this.android_id;
        }

        public String getAd_id() {
            if (this.ad_id == null || this.ad_id.length() == 0) {
                return "";
            }
            return this.ad_id;
        }

        public String getDevice_id() {
            if (this.device_id == null || this.device_id.length() == 0) {
                return "";
            }
            return this.device_id;
        }

        public String getAd_not_track() {
            if (this.ad_not_track == null || this.ad_not_track.length() == 0) {
                return "";
            }
            return this.ad_not_track;
        }

        public String getBrightness() {
            if (this.brightness == null || this.brightness.length() == 0) {
                return "";
            }
            return this.brightness;
        }

        public String getBluetooth_mac() {
            if (this.bluetooth_mac == null || this.bluetooth_mac.length() == 0) {
                return "";
            }
            return this.bluetooth_mac;
        }

        public String getCpu_frequency() {
            if (this.cpu_frequency == null || this.cpu_frequency.length() == 0) {
                return "";
            }
            return this.cpu_frequency;
        }

        public String getCpu_type() {
            if (this.cpu_type == null || this.cpu_type.length() == 0) {
                return "";
            }
            return this.cpu_type;
        }

        public String getCpu_hardware() {
            if (this.cpu_hardware == null || this.cpu_hardware.length() == 0) {
                return "";
            }
            return this.cpu_hardware;
        }

        public String getTotal_memory() {
            if (this.total_memory == null || this.total_memory.length() == 0) {
                return "";
            }
            return this.total_memory;
        }

        public String getAvailable_memory() {
            if (this.available_memory == null || this.available_memory.length() == 0) {
                return "";
            }
            return this.available_memory;
        }

        public String getMax_heap_size() {
            if (this.max_heap_size == null || this.max_heap_size.length() == 0) {
                return "";
            }
            return this.max_heap_size;
        }

        public String getHeap_allocation_percent() {
            if (this.heap_allocation_percent == null || this.heap_allocation_percent.length() == 0) {
                return "";
            }
            return this.heap_allocation_percent;
        }

        public String getHeap_used_percent() {
            if (this.heap_used_percent == null || this.heap_used_percent.length() == 0) {
                return "";
            }
            return this.heap_used_percent;
        }

        public String getTotal_internal_storage() {
            if (this.total_internal_storage == null || this.total_internal_storage.length() == 0) {
                return "";
            }
            return this.total_internal_storage;
        }

        public String getAvailable_internal_storage() {
            if (this.available_internal_storage == null || this.available_internal_storage.length() == 0) {
                return "";
            }
            return this.available_internal_storage;
        }

        public String getTotal_external_storage() {
            if (this.total_external_storage == null || this.total_external_storage.length() == 0) {
                return "";
            }
            return this.total_external_storage;
        }

        public String getAvailable_external_storage() {
            if (this.available_external_storage == null || this.available_external_storage.length() == 0) {
                return "";
            }
            return this.available_external_storage;
        }

        public String getRooted() {
            if (this.rooted == null || this.rooted.length() == 0) {
                return "";
            }
            return this.rooted;
        }

        public String getEmulator() {
            if (this.emulator == null || this.emulator.length() == 0) {
                return "";
            }
            return this.emulator;
        }

        public String getOrientation() {
            if (this.orientation == null || this.orientation.length() == 0) {
                return "";
            }
            return this.orientation;
        }

        public String getKernel_version() {
            if (this.kernel_version == null || this.kernel_version.length() == 0) {
                return "";
            }
            return this.kernel_version;
        }

        public String getFont_hash() {
            if (this.font_hash == null || this.font_hash.length() == 0) {
                return "";
            }
            return this.font_hash;
        }

        public String getAllow_mock_location() {
            if (this.allow_mock_location == null || this.allow_mock_location.length() == 0) {
                return "";
            }
            return this.allow_mock_location;
        }

        public String getBattery_status() {
            if (this.battery_status == null || this.battery_status.length() == 0) {
                return "";
            }
            return this.battery_status;
        }

        public String getBattery_level() {
            if (this.battery_level == null || this.battery_level.length() == 0) {
                return "";
            }
            return this.battery_level;
        }

        public String getBattery_temperature() {
            if (this.battery_temperature == null || this.battery_temperature.length() == 0) {
                return "";
            }
            return this.battery_temperature;
        }
    }
}

