/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.data.properties.sources;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nhnent.owl.android.feed.data.properties.BaseProperties;
import com.nhnent.owl.android.feed.data.properties.Retriever;
import com.nhnent.owl.android.feed.data.utils.CommonUtil;
import com.nhnent.owl.android.feed.listener.MainActivityEventListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ApplicationProperties
extends BaseProperties
implements MainActivityEventListener.Listener {
    private _application app = new _application();

    public ApplicationProperties(@NonNull Context context) {
        super(context);
    }

    @Override
    public void reset() {
    }

    @Override
    public void retrieve(Retriever.PropertyCallback callback) {
        this.app.lib_version = "1.0.0";
        this.app.package_name = this.ctx.getPackageName();
        try {
            ApplicationInfo applicationInfo = this.ctx.getApplicationInfo();
            if (applicationInfo != null) {
                this.app.source_dir = applicationInfo.sourceDir;
                this.app.debug = Boolean.toString((applicationInfo.flags & 2) != 0);
                this.app.uid = String.valueOf(applicationInfo.uid);
                int stringId = applicationInfo.labelRes;
                if (stringId == 0) {
                    if (applicationInfo.nonLocalizedLabel != null) {
                        this.app.name = applicationInfo.nonLocalizedLabel.toString();
                    }
                } else {
                    this.app.name = this.ctx.getString(stringId);
                }
            }
            Boolean isOpenUnknownSources = Build.VERSION.SDK_INT >= 17 && Build.VERSION.SDK_INT < 21 ? Boolean.valueOf(Settings.Secure.getInt((ContentResolver)this.ctx.getContentResolver(), (String)"install_non_market_apps") == 1) : Boolean.valueOf(Settings.Secure.getInt((ContentResolver)this.ctx.getContentResolver(), (String)"install_non_market_apps") == 1);
            this.app.open_unknown_sources = String.valueOf(isOpenUnknownSources);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            PackageInfo packageInfo = this.ctx.getPackageManager().getPackageInfo(this.ctx.getPackageName(), 64);
            this.app.version = packageInfo.versionName;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.app.first_install_time = format.format(new Date(packageInfo.firstInstallTime));
            this.app.last_update_time = format.format(new Date(packageInfo.lastUpdateTime));
            if (packageInfo.signatures != null) {
                Signature signature = packageInfo.signatures[0];
                this.app.signature_md5 = CommonUtil.getMessageDigest(signature.toByteArray());
            }
            this.app.apk_md5 = CommonUtil.getMd5ByFile(new File(this.ctx.getApplicationInfo().sourceDir));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        this.app.permissions.get_accounts = ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.GET_ACCOUNTS") == 0 ? "true" : "false";
        this.app.permissions.access_coarse_location = ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 ? "true" : "false";
        this.app.permissions.access_network_state = ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_NETWORK_STATE") == 0 ? "true" : "false";
        this.app.permissions.access_wifi_state = ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_WIFI_STATE") == 0 ? "true" : "false";
        this.app.permissions.access_fine_location = ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 ? "true" : "false";
        this.app.permissions.read_phone_state = ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.READ_PHONE_STATE") == 0 ? "true" : "false";
        callback.onComplete(this.app);
    }

    @Override
    public void onBecameBackground() {
        this.app.status = "background";
    }

    @Override
    public void onBecameForeground() {
        this.app.status = "foreground";
    }

    @Override
    public void checkUnGrantedPermission() {
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        String json = gson.toJson((Object)this.app);
        return json;
    }

    public class Permission {
        String read_phone_state;
        String access_fine_location;
        String access_coarse_location;
        String access_network_state;
        String access_wifi_state;
        String get_accounts;
    }

    public class _application {
        private String name;
        private String uid;
        private String package_name;
        private String version;
        private String last_update_time;
        private String first_install_time;
        private String lib_version;
        private String source_dir;
        private String signature_md5;
        private String apk_md5;
        private String open_unknown_sources;
        private String debug;
        private String status;
        Permission permissions;

        _application() {
            this.permissions = new Permission();
        }

        public String getName() {
            if (this.name == null || this.name.length() == 0) {
                return "";
            }
            return this.name;
        }

        public String getUid() {
            if (this.uid == null || this.uid.length() == 0) {
                return "";
            }
            return this.uid;
        }

        public String getPackage_name() {
            if (this.package_name == null || this.package_name.length() == 0) {
                return "";
            }
            return this.package_name;
        }

        public String getVersion() {
            if (this.version == null || this.version.length() == 0) {
                return "";
            }
            return this.version;
        }

        public String getLast_update_time() {
            if (this.last_update_time == null || this.last_update_time.length() == 0) {
                return "";
            }
            return this.last_update_time;
        }

        public String getFirst_install_time() {
            if (this.first_install_time == null || this.first_install_time.length() == 0) {
                return "";
            }
            return this.first_install_time;
        }

        public String getLib_version() {
            if (this.lib_version == null || this.lib_version.length() == 0) {
                return "";
            }
            return this.lib_version;
        }

        public String getSource_dir() {
            if (this.source_dir == null || this.source_dir.length() == 0) {
                return "";
            }
            return this.source_dir;
        }

        public String getSignature_md5() {
            if (this.signature_md5 == null || this.signature_md5.length() == 0) {
                return "";
            }
            return this.signature_md5;
        }

        public String getApk_md5() {
            if (this.apk_md5 == null || this.apk_md5.length() == 0) {
                return "";
            }
            return this.apk_md5;
        }

        public String getOpen_unknown_sources() {
            if (this.open_unknown_sources == null || this.open_unknown_sources.length() == 0) {
                return "";
            }
            return this.open_unknown_sources;
        }

        public String getDebug() {
            if (this.debug == null || this.debug.length() == 0) {
                return "";
            }
            return this.debug;
        }

        public String getStatus() {
            if (this.status == null || this.status.length() == 0) {
                return "";
            }
            return this.status;
        }

        public Permission getPermissions() {
            return this.permissions;
        }
    }
}

