/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.data.properties.sources;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.UserManager;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nhnent.owl.android.feed.data.properties.BaseProperties;
import com.nhnent.owl.android.feed.data.properties.Retriever;
import com.nhnent.owl.android.feed.data.utils.CommonUtil;
import java.util.ArrayList;

public class AccountProperties
extends BaseProperties {
    private _account account = new _account();

    public AccountProperties(@NonNull Context context) {
        super(context);
    }

    @Override
    public void reset() {
    }

    public void setUserId(String userId) {
        this.account.user_id = userId;
    }

    @Override
    public void retrieve(Retriever.PropertyCallback callback) {
        Account[] accounts;
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.GET_ACCOUNTS") == 0 && (accounts = AccountManager.get((Context)this.ctx).getAccountsByType("com.google")).length > 0) {
            ArrayList<String> scanAccounts = new ArrayList<String>();
            for (int i = 0; i < accounts.length; ++i) {
                scanAccounts.add(accounts[i].name);
            }
            this.account.name = CommonUtil.ListToString(scanAccounts, ",");
        }
        if (Build.VERSION.SDK_INT >= 17) {
            UserManager um = (UserManager)this.ctx.getSystemService("user");
            this.account.user_agoat = String.valueOf(um.isUserAGoat());
        }
        if (Build.VERSION.SDK_INT >= 8) {
            this.account.user_amonkey = String.valueOf(ActivityManager.isUserAMonkey());
        }
        callback.onComplete(this.account);
    }

    @Override
    public void checkUnGrantedPermission() {
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.GET_ACCOUNTS") != 0) {
            this.ungrantedPermissions.add("android.permission.GET_ACCOUNTS");
        }
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        String json = gson.toJson((Object)this.account);
        return json;
    }

    public class _account {
        private String name;
        private String user_agoat;
        private String user_amonkey;
        private String user_id;

        public String getName() {
            if (this.name == null || this.name.length() == 0) {
                return "";
            }
            return this.name;
        }

        public String getUser_agoat() {
            if (this.user_agoat == null || this.user_agoat.length() == 0) {
                return "";
            }
            return this.user_agoat;
        }

        public String getUser_amonkey() {
            if (this.user_amonkey == null || this.user_amonkey.length() == 0) {
                return "";
            }
            return this.user_amonkey;
        }
    }
}

