/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.backup;

import android.app.backup.BackupManager;
import android.content.Context;
import android.util.Log;

public class WrapperBackupAgent {
    private static final String TAG = "Feed." + WrapperBackupAgent.class.getSimpleName();
    private static Boolean backupManagerAvailable = null;

    public static boolean isAvailable() {
        if (backupManagerAvailable == null) {
            try {
                Class.forName("android.app.backup.BackupManager");
                backupManagerAvailable = true;
            }
            catch (Exception e) {
                backupManagerAvailable = false;
            }
        }
        return backupManagerAvailable;
    }

    public static void dataChanged(Context context) {
        if (WrapperBackupAgent.isAvailable()) {
            BackupManager wrappedInstance = new BackupManager(context);
            wrappedInstance.dataChanged();
            Log.d((String)TAG, (String)"Backup functionality is available. Backing up device id.");
        } else {
            Log.w((String)TAG, (String)"Backup functionality is NOT AVAILABLE.");
        }
    }
}

