/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.api;

import android.content.Context;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.Response;
import com.koushikdutta.ion.builder.Builders;
import com.nhnent.owl.android.feed.api.FeedCallback;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OwlMateApi {
    private static final String TAG = "Feed." + OwlMateApi.class.getName();
    private static OwlMateApi self;
    private static Context context;
    private static final String API_BASE_URL = "http://nest.nhnent.com/nest";
    private static final String API_VERSION = "/v1";
    private static final String apiAuth = "http://nest.nhnent.com/nest/v1/auth";
    private static final String apiHoot = "http://nest.nhnent.com/nest/v1/hoot";
    private static final String apiHiss = "http://nest.nhnent.com/nest/v1/hiss";

    public static OwlMateApi getInstance(Context context) {
        if (self == null) {
            self = new OwlMateApi(context);
        }
        return self;
    }

    public static Context getContext() {
        return context;
    }

    private OwlMateApi(Context context) {
        OwlMateApi.context = context;
    }

    public static void auth(String payload, final FeedCallback callback) {
        try {
            ((Builders.Any.F)((Builders.Any.B)((Builders.Any.B)Ion.with((Context)OwlMateApi.getContext()).load("POST", apiAuth)).addHeader("Content-Type", "text/plain")).setStringBody(payload)).asString().withResponse().setCallback((FutureCallback)new FutureCallback<Response<String>>(){

                public void onCompleted(Exception exception, Response<String> response) {
                    if (exception == null) {
                        OwlMateApi.handleResponse((Response<String>)response, callback);
                    } else {
                        exception.printStackTrace();
                        Log.e((String)TAG, (String)("Post request exception:" + exception.toString()));
                        callback.onError("server_error", Arrays.asList(exception.getLocalizedMessage()));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void hiss(final FeedCallback callback) {
        try {
            ((Builders.Any.B)Ion.with((Context)OwlMateApi.getContext()).load("GET", apiHiss)).asString().withResponse().setCallback((FutureCallback)new FutureCallback<Response<String>>(){

                public void onCompleted(Exception exception, Response<String> response) {
                    if (exception == null) {
                        OwlMateApi.handleResponse((Response<String>)response, callback);
                    } else {
                        Log.e((String)TAG, (String)("Get request exception:" + exception.toString()));
                        callback.onError("server_error", Arrays.asList(exception.getLocalizedMessage()));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void hoot(String payload, String token, final FeedCallback callback) {
        try {
            ((Builders.Any.F)((Builders.Any.B)((Builders.Any.B)((Builders.Any.B)Ion.with((Context)OwlMateApi.getContext()).load("POST", apiHoot)).addHeader("content-type", "text/plain")).addHeader("Authorization", token)).setStringBody(payload)).asString().withResponse().setCallback((FutureCallback)new FutureCallback<Response<String>>(){

                public void onCompleted(Exception exception, Response<String> response) {
                    if (exception == null) {
                        OwlMateApi.handleResponse((Response<String>)response, callback);
                    } else {
                        Log.e((String)TAG, (String)("Post request exception:" + exception.toString()));
                        callback.onError("server_error", Arrays.asList(exception.getLocalizedMessage()));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleResponse(Response<String> response, FeedCallback callback) {
        if (response.getHeaders().code() < 500) {
            if (response.getHeaders().code() >= 400) {
                OwlMateApi.catchError(response, callback);
            } else {
                try {
                    String string = new String(((String)response.getResult()).getBytes(), "UTF-8");
                    JsonElement result = (JsonElement)new Gson().fromJson(string, JsonElement.class);
                    if (result.isJsonArray()) {
                        callback.onSuccess(result.getAsJsonArray());
                    } else {
                        callback.onSuccess(OwlMateApi.jsonObjectToArray(result.getAsJsonObject()));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    callback.onError("parse_error", Arrays.asList("can't parse utf8"));
                }
            }
        }
    }

    private static void catchError(Response<String> response, FeedCallback callback) {
        if (response.getResult() == null) {
            callback.onError("server_error", Arrays.asList(response.getHeaders().message()));
        } else {
            JsonObject result = (JsonObject)new Gson().fromJson((String)response.getResult(), JsonObject.class);
            Set entries = result.entrySet();
            for (Map.Entry entry : entries) {
                if (((JsonElement)entry.getValue()).isJsonArray()) {
                    callback.onError((String)entry.getKey(), OwlMateApi.jsonArrayToList(((JsonElement)entry.getValue()).getAsJsonArray()));
                }
                callback.onError((String)entry.getKey(), Collections.singletonList(((JsonElement)entry.getValue()).getAsString()));
            }
        }
    }

    private static JsonArray jsonObjectToArray(JsonObject jsonObject) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((JsonElement)jsonObject);
        return jsonArray;
    }

    private static List<String> jsonArrayToList(JsonArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            jsonArray.get(i).getAsString();
        }
        return list;
    }
}

