/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed;

import android.content.Context;
import android.util.Log;
import com.nhnent.owl.android.feed.backup.WrapperBackupAgent;
import com.nhnent.owl.android.feed.identification.DeviceIdentityProvider;

public class FeedObserver {
    private static final String TAG = "Feed." + FeedObserver.class.getSimpleName();
    private static String sID = null;
    private static DeviceIdentityProvider identityProvider;

    public static synchronized String getDeviceId(Context context) {
        if (sID == null) {
            try {
                identityProvider = DeviceIdentityProvider.getInstance(context);
                if (identityProvider.isNewDevice()) {
                    WrapperBackupAgent.dataChanged(context);
                    Log.d((String)TAG, (String)"dataChanged");
                }
                sID = identityProvider.getDeviceId();
                Log.d((String)TAG, (String)("deviceId: " + sID));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sID;
    }

    public static synchronized void setNestId(Context context, String nestId) {
        identityProvider = DeviceIdentityProvider.getInstance(context);
        identityProvider.setNestId(nestId);
    }

    public static synchronized String getNestId(Context context) {
        identityProvider = DeviceIdentityProvider.getInstance(context);
        return identityProvider.getNestId();
    }
}

