/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.persistent;

import android.content.Context;
import android.content.SharedPreferences;
import com.nhnent.owl.android.feed.persistent.KeyValueStore;

public class SharedPreferencesStore
implements KeyValueStore {
    public static final String DEFAULT_PREFERENCE_FILE = "prefs_default";
    private SharedPreferences mPreferences;

    public SharedPreferencesStore(Context context) {
        this(context, DEFAULT_PREFERENCE_FILE, false);
    }

    public SharedPreferencesStore(Context context, boolean secure) {
        this(context, DEFAULT_PREFERENCE_FILE, secure);
    }

    public SharedPreferencesStore(Context context, String filename, boolean secure) {
        this.mPreferences = SharedPreferencesStore.init(context, filename, secure);
    }

    private static SharedPreferences init(Context context, String filename, boolean secure) {
        SharedPreferences prefs = context.getSharedPreferences(filename, 0);
        if (secure) {
            // empty if block
        }
        return prefs;
    }

    @Override
    public void clear() {
        this.mPreferences.edit().clear().apply();
    }

    @Override
    public boolean contains(String key) {
        return this.mPreferences.contains(key);
    }

    @Override
    public String get(String key) {
        return this.mPreferences.getString(key, null);
    }

    @Override
    public String put(String key, String value) {
        String old = this.mPreferences.getString(key, null);
        this.mPreferences.edit().putString(key, value).apply();
        return old;
    }

    @Override
    public String remove(String key) {
        String old = this.mPreferences.getString(key, null);
        this.mPreferences.edit().remove(key).apply();
        return old;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.mPreferences.getAll().isEmpty();
    }
}

