/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.listener;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import com.nhnent.owl.android.feed.Feeds;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@TargetApi(value=14)
public class MainActivityEventListener
implements Application.ActivityLifecycleCallbacks {
    public static final String TAG = "Feed." + MainActivityEventListener.class.getSimpleName();
    private Activity mainActivity;
    protected final String appKey;
    private boolean foreground;
    private int activityCount;
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public MainActivityEventListener(Activity mainActivity, String appKey) {
        this.mainActivity = mainActivity;
        this.appKey = appKey;
    }

    public void resolve() {
        this.mainActivity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public boolean isBackground() {
        return !this.foreground;
    }

    public int getActivityCount() {
        return this.activityCount;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void onActivityPaused(Activity activity) {
        this.foreground = false;
        for (Listener l : this.listeners) {
            try {
                l.onBecameBackground();
            }
            catch (Exception exc) {
                Log.e((String)TAG, (String)"Listener threw exception!", (Throwable)exc);
            }
        }
    }

    public void onActivityResumed(Activity activity) {
        this.foreground = true;
        for (Listener l : this.listeners) {
            try {
                l.onBecameForeground();
            }
            catch (Exception exc) {
                Log.e((String)TAG, (String)"Listener threw exception!", (Throwable)exc);
            }
        }
    }

    public void onActivityStarted(Activity activity) {
        ++this.activityCount;
        if (activity == this.mainActivity) {
            Log.d((String)TAG, (String)"onActivityStarted");
            Feeds.sharedInstance().onStart();
        }
    }

    public void onActivityStopped(Activity activity) {
        --this.activityCount;
        if (activity == this.mainActivity) {
            Log.d((String)TAG, (String)"onActivityStopped");
            Feeds.sharedInstance().onStop();
        }
        Log.d((String)activity.getClass().getSimpleName(), (String)(" :onActivityStopped\uff0c" + this.activityCount));
        if (this.activityCount == 0) {
            this.foreground = false;
        }
    }

    public void onActivityDestroyed(Activity activity) {
        if (activity == this.mainActivity) {
            Log.d((String)TAG, (String)"onActivityDestroyed");
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public static interface Listener {
        public void onBecameForeground();

        public void onBecameBackground();
    }
}

