/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.listener;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.Log;

public class DeviceLocationListener
extends Service
implements LocationListener {
    private static final String TAG = "Feed." + DeviceLocationListener.class.getSimpleName();
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 10L;
    private static final long MIN_TIME_BW_UPDATES = 60000L;
    boolean canGetLocation = false;
    private Context context = null;
    boolean isGPSEnabled = false;
    boolean isNetworkEnabled = false;
    public double latitude = 0.0;
    private Location location = null;
    private LocationManager locationManager = null;
    public double longitude = 0.0;

    public DeviceLocationListener(Context ctx) {
        this.context = ctx;
        this.setLocation();
    }

    public void setLocation() {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        try {
            this.locationManager = (LocationManager)this.context.getSystemService("location");
            this.isGPSEnabled = this.locationManager.isProviderEnabled("gps");
            this.isNetworkEnabled = this.locationManager.isProviderEnabled("network");
            if (!this.isGPSEnabled && !this.isNetworkEnabled) {
                Log.d((String)TAG, (String)"Check your mobile connection provider");
            } else {
                this.canGetLocation = true;
                if (this.isNetworkEnabled) {
                    this.locationManager.requestLocationUpdates("network", 60000L, 10.0f, (LocationListener)this);
                    Log.d((String)TAG, (String)"Network requestLocationUpdates");
                    if (this.locationManager != null) {
                        this.location = this.locationManager.getLastKnownLocation("network");
                        if (this.location != null) {
                            this.latitude = this.location.getLatitude();
                            this.longitude = this.location.getLongitude();
                        }
                    }
                } else {
                    Log.d((String)TAG, (String)"disable network location provider");
                }
                if (this.isGPSEnabled) {
                    this.locationManager.requestLocationUpdates("gps", 60000L, 10.0f, (LocationListener)this);
                    Log.d((String)TAG, (String)"GPS requestLocationUpdates");
                    if (this.locationManager != null) {
                        this.location = this.locationManager.getLastKnownLocation("gps");
                        if (this.location != null) {
                            this.latitude = this.location.getLatitude();
                            this.longitude = this.location.getLongitude();
                        }
                    }
                } else {
                    Log.d((String)TAG, (String)"disable gps location provider");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onLocationChanged(Location location) {
        double latitude = location.getLatitude();
        double longitude = location.getLongitude();
        Log.d((String)TAG, (String)("onLocationChanged - provider : " + location.getProvider() + ", latitude : " + latitude + " , longitude : " + longitude));
        if (this.locationManager != null) {
            this.locationManager.removeUpdates((LocationListener)this);
        }
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }
}

