/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.identification;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.nhnent.owl.android.feed.identification.DeviceIdentifier;
import com.nhnent.owl.android.feed.persistent.KeyValueStore;
import com.nhnent.owl.android.feed.persistent.SharedPreferencesStore;
import java.util.Date;

public class DeviceIdentityProvider {
    private static final String TAG = "Feed." + DeviceIdentityProvider.class.getSimpleName();
    public static final String PREF_FEED_FILE = "prefs_feed";
    public static final String DEVICE_ID_KEY = "deviceId";
    public static final String DEVICE_ID_TIMESTAMP = "deviceIdTimestamp";
    private static DeviceIdentityProvider instance;
    private Context mContext;
    private KeyValueStore mIdentityStore;
    private boolean mNewDevice;

    public static synchronized DeviceIdentityProvider getInstance(Context context) {
        if (instance == null) {
            instance = new DeviceIdentityProvider(context);
        }
        return instance;
    }

    private DeviceIdentityProvider(Context context) {
        this.mContext = context;
        this.mIdentityStore = new SharedPreferencesStore(context, PREF_FEED_FILE, true);
        this.init();
    }

    private void init() {
        this.mNewDevice = false;
        if (!this.mIdentityStore.contains(DEVICE_ID_KEY) || TextUtils.isEmpty((CharSequence)this.mIdentityStore.get(DEVICE_ID_KEY))) {
            this.mIdentityStore.put(DEVICE_ID_KEY, this.generateDeviceId());
            this.mIdentityStore.put(DEVICE_ID_TIMESTAMP, String.valueOf(new Date().getTime()));
            this.mNewDevice = true;
        } else {
            String deviceId;
            String storeId = this.mIdentityStore.get(DEVICE_ID_KEY);
            if (!storeId.equalsIgnoreCase(deviceId = this.generateDeviceId())) {
                Log.w((String)TAG, (String)"device_id is change!!");
                this.mIdentityStore.put(DEVICE_ID_KEY, deviceId);
                this.mIdentityStore.put(DEVICE_ID_TIMESTAMP, String.valueOf(new Date().getTime()));
                this.mNewDevice = true;
            } else {
                Log.d((String)TAG, (String)"device_id is same");
            }
        }
    }

    public String getDeviceId() {
        return this.mIdentityStore.get(DEVICE_ID_KEY);
    }

    public String generateDeviceId() {
        try {
            return DeviceIdentifier.getDeviceIdentifier(this.mContext, true);
        }
        catch (DeviceIdentifier.DeviceIDException e) {
            return DeviceIdentifier.getPseudoDeviceId(this.mContext);
        }
    }

    public KeyValueStore getIdentityStore() {
        return this.mIdentityStore;
    }

    public void setIdentityStore(KeyValueStore identityStore) {
        this.mIdentityStore = identityStore;
        this.init();
    }

    public boolean isNewDevice() {
        return this.mNewDevice;
    }

    public void setNestId(String nestId) {
        this.mIdentityStore.put("nestId", nestId);
    }

    public String getNestId() {
        return this.mIdentityStore.get("nestId");
    }
}

