/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.data.utils;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.util.Log;
import com.nhnent.owl.android.feed.data.utils.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class DeviceUtil {
    private static long sMaxCpuFreq = 0L;
    private static int sTotalMemory = 0;

    public static long getMaxCpuFreq() {
        if (sMaxCpuFreq > 0L) {
            return sMaxCpuFreq;
        }
        String cpuFreq = "";
        try {
            String[] args = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq"};
            ProcessBuilder cmd = new ProcessBuilder(args);
            Process process = cmd.start();
            InputStream in = process.getInputStream();
            byte[] re = new byte[24];
            while (in.read(re) != -1) {
                cpuFreq = cpuFreq + new String(re);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            cpuFreq = "";
        }
        cpuFreq = cpuFreq.trim();
        if (cpuFreq == null || cpuFreq.length() == 0) {
            sMaxCpuFreq = 1L;
        } else {
            try {
                sMaxCpuFreq = Long.parseLong(cpuFreq);
            }
            catch (NumberFormatException e) {
                sMaxCpuFreq = 1L;
                e.printStackTrace();
            }
        }
        return sMaxCpuFreq;
    }

    public static int getTotalMemoryInMb() {
        return DeviceUtil.getTotalMemoryInKb() >> 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTotalMemoryInKb() {
        if (sTotalMemory > 0) {
            return sTotalMemory;
        }
        String str1 = "/proc/meminfo";
        String str2 = "";
        FileReader fr = null;
        BufferedReader localBufferedReader = null;
        try {
            fr = new FileReader(str1);
            localBufferedReader = new BufferedReader(fr, 8192);
            str2 = localBufferedReader.readLine();
            if (str2 != null) {
                String[] arrayOfString = str2.split("\\s+");
                sTotalMemory = Integer.valueOf(arrayOfString[1]);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
                if (localBufferedReader != null) {
                    localBufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sTotalMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFreeMemoryInKb() {
        String str1 = "/proc/meminfo";
        String str2 = "";
        FileReader fr = null;
        BufferedReader localBufferedReader = null;
        int freeMem = 0;
        try {
            fr = new FileReader(str1);
            localBufferedReader = new BufferedReader(fr, 8192);
            int line = 0;
            while ((str2 = localBufferedReader.readLine()) != null) {
                if (++line != 2) continue;
                String[] arrayOfString = str2.split("\\s+");
                freeMem = Integer.valueOf(arrayOfString[1]);
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
                if (localBufferedReader != null) {
                    localBufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return freeMem;
    }

    public static long getMaxHeapSizeInBytes(Context context) {
        long max = Runtime.getRuntime().maxMemory();
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            long memoryClass = am.getMemoryClass() << 20;
            if (max > memoryClass) {
                max = memoryClass;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return max;
    }

    public static float getHeapAllocatePercent() {
        long heapAllocated = Runtime.getRuntime().totalMemory();
        long heapMax = Runtime.getRuntime().maxMemory();
        return (float)Math.round((float)heapAllocated * 10000.0f / (float)heapMax) / 100.0f;
    }

    public static float getHeapUsedPercent(Context context) {
        long heapUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long heapMax = DeviceUtil.getMaxHeapSizeInBytes(context);
        return (float)Math.round((float)heapUsed * 10000.0f / (float)heapMax) / 100.0f;
    }

    public static long getHeapRemainInBytes(Context context) {
        return DeviceUtil.getMaxHeapSizeInBytes(context) - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    public static String getCpuHardware() {
        String r = null;
        ProcessBuilder pb = new ProcessBuilder("/system/bin/cat", "/proc/cpuinfo");
        try {
            String result;
            Process process = pb.start();
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((result = bufferedReader.readLine()) != null) {
                if (!result.contains("Hardware")) continue;
                String[] a = result.split(":", 2);
                r = a[1];
            }
            bufferedReader.close();
            return r;
        }
        catch (IOException e) {
            e.printStackTrace();
            return r;
        }
    }

    public static String getCpuName() {
        String result = DeviceUtil.getArmCPUName();
        if (result == null) {
            result = DeviceUtil.getX86CPUName();
        }
        if (result == null) {
            result = DeviceUtil.getMIPSCPUName();
        }
        return result;
    }

    public static String getX86CPUName() {
        String aLine = "Intel";
        if (new File("/proc/cpuinfo").exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(new File("/proc/cpuinfo")));
                String[] strArray = new String[2];
                while ((aLine = br.readLine()) != null) {
                    if (!aLine.contains("model name")) continue;
                    br.close();
                    strArray = aLine.split(":", 2);
                    aLine = strArray[1];
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return aLine;
    }

    public static String getMIPSCPUName() {
        String aLine = "MIPS";
        if (new File("/proc/cpuinfo").exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(new File("/proc/cpuinfo")));
                String[] strArray = new String[2];
                while ((aLine = br.readLine()) != null) {
                    if (!aLine.contains("cpu model")) continue;
                    br.close();
                    strArray = aLine.split(":", 2);
                    aLine = strArray[1];
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return aLine;
    }

    public static String getArmCPUName() {
        try {
            FileReader fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            br.close();
            String[] array = text.split(":\\s+", 2);
            if (array.length >= 2) {
                return array[1];
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean externalMemoryAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getAvailableInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = DeviceUtil.getBlockSize(stat);
        long availableBlocks = DeviceUtil.getAvailableBlockCount(stat);
        return CommonUtil.formatSize(availableBlocks * blockSize);
    }

    public static String getTotalInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = DeviceUtil.getBlockSize(stat);
        long totalBlocks = DeviceUtil.getBlockCount(stat);
        return CommonUtil.formatSize(totalBlocks * blockSize);
    }

    public static String getAvailableExternalMemorySize() {
        if (DeviceUtil.externalMemoryAvailable()) {
            File path = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = DeviceUtil.getBlockSize(stat);
            long availableBlocks = DeviceUtil.getAvailableBlockCount(stat);
            return CommonUtil.formatSize(availableBlocks * blockSize);
        }
        return null;
    }

    public static String getTotalExternalMemorySize() {
        if (DeviceUtil.externalMemoryAvailable()) {
            File path = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = DeviceUtil.getBlockSize(stat);
            long totalBlocks = DeviceUtil.getBlockCount(stat);
            return CommonUtil.formatSize(totalBlocks * blockSize);
        }
        return null;
    }

    private static long getBlockSize(StatFs statFs) {
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs.getBlockSizeLong();
        }
        return statFs.getBlockSize();
    }

    private static long getBlockCount(StatFs statFs) {
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs.getBlockCountLong();
        }
        return statFs.getBlockCount();
    }

    private static long getAvailableBlockCount(StatFs statFs) {
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs.getAvailableBlocksLong();
        }
        return statFs.getAvailableBlocks();
    }

    public static boolean isRooted() {
        String[] probableRootPaths;
        if (Build.TAGS != null && Build.TAGS.contains("test-keys")) {
            return true;
        }
        for (String probableRootPath : probableRootPaths = new String[]{"/data/local/bin/su", "/data/local/su", "/data/local/xbin/su", "/sbin/su", "/su/bin", "/su/bin/su", "/system/app/SuperSU", "/system/app/SuperSU.apk", "/system/app/Superuser", "/system/app/Superuser.apk", "/system/bin/failsafe/su", "/system/bin/su", "/system/sd/xbin/su", "/system/xbin/daemonsu", "/system/xbin/su"}) {
            try {
                if (!new File(probableRootPath).exists()) continue;
                return true;
            }
            catch (Exception e) {
                Log.e((String)"DeviceUtil", (String)"Exception while attempting to detect whether the device is rooted", (Throwable)e);
            }
        }
        return false;
    }

    public static String getWifiMacAddress() {
        try {
            String interfaceName = "wlan0";
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                if (!intf.getName().equalsIgnoreCase(interfaceName)) continue;
                byte[] mac = intf.getHardwareAddress();
                if (mac == null) {
                    return "";
                }
                StringBuilder buf = new StringBuilder();
                for (byte aMac : mac) {
                    buf.append(String.format("%02X:", aMac));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                return buf.toString();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return "";
    }

    public static String getLocalIpAddress() {
        try {
            if (NetworkInterface.getNetworkInterfaces() != null) {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    if (intf == null) continue;
                    Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address) || inetAddress.getHostAddress().equals("null") || inetAddress.getHostAddress() == null) continue;
                        return inetAddress.getHostAddress().trim();
                    }
                }
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return "";
    }

    public static String getMACAddress(String interfaceName) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                if (interfaceName != null && !intf.getName().equalsIgnoreCase(interfaceName)) continue;
                byte[] mac = intf.getHardwareAddress();
                if (mac == null) {
                    return "";
                }
                StringBuilder buf = new StringBuilder();
                for (int idx = 0; idx < mac.length; ++idx) {
                    buf.append(String.format("%02X:", mac[idx]));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                return buf.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getIPAddress(boolean useIPv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    boolean isIPv4;
                    if (addr.isLoopbackAddress()) continue;
                    String sAddr = addr.getHostAddress();
                    boolean bl = isIPv4 = sAddr.indexOf(58) < 0;
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return sAddr;
                    }
                    if (isIPv4) continue;
                    int delim = sAddr.indexOf(37);
                    return delim < 0 ? sAddr.toUpperCase() : sAddr.substring(0, delim).toUpperCase();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static boolean isMockLocationEnabled(@NonNull Context context) {
        boolean isMockLocation = false;
        try {
            AppOpsManager opsManager;
            isMockLocation = Build.VERSION.SDK_INT >= 23 ? (opsManager = (AppOpsManager)context.getSystemService("appops")).checkOp("android:mock_location", android.os.Process.myUid(), context.getPackageName()) == 0 : !Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"mock_location").equals("0");
        }
        catch (Exception e) {
            return isMockLocation;
        }
        return isMockLocation;
    }
}

