/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.data.utils;

import android.annotation.SuppressLint;
import java.io.File;
import java.io.FileInputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CommonUtil {
    public static String formatSize(long size) {
        StringBuilder resultBuffer = new StringBuilder(Long.toString(size));
        return resultBuffer.toString();
    }

    public static String ListToString(List<String> list, String delimiter) {
        HashSet<String> set = new HashSet<String>(list);
        ArrayList<String> result = new ArrayList<String>(set);
        int len = result.size();
        if (len > 0) {
            int last = len - 1;
            String[] theArray = result.toArray(new String[len]);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < theArray.length; ++i) {
                String item = theArray[i];
                if ((item = item.replaceAll("\"", "")).length() <= 0) continue;
                sb.append(item);
                if (last == i) continue;
                sb.append(delimiter);
            }
            return sb.toString();
        }
        return null;
    }

    public static String getMessageDigest(byte[] buffer) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(buffer);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMd5ByFile(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            MappedByteBuffer byteBuffer = in.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(byteBuffer);
            String hex = CommonUtil.byteToHexString(digest.digest());
            return hex;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String byteToHexString(byte[] b) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                buffer.append(0);
            }
            buffer.append(hex);
        }
        return buffer.toString();
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String formatIpInt(int address) {
        byte[] addr = new byte[]{(byte)(address >>> 24 & 0xFF), (byte)(address >>> 16 & 0xFF), (byte)(address >>> 8 & 0xFF), (byte)(address & 0xFF)};
        return String.format("%1$d.%2$d.%3$d.%4$d", addr[3] & 0xFF, addr[2] & 0xFF, addr[1] & 0xFF, addr[0] & 0xFF);
    }
}

