/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.data.properties.sources;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nhnent.owl.android.feed.data.properties.BaseProperties;
import com.nhnent.owl.android.feed.data.properties.Retriever;
import com.nhnent.owl.android.feed.listener.DeviceLocationListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class LocationProperties
extends BaseProperties {
    private static final String TAG = "Feed." + LocationProperties.class.getSimpleName();
    private _location location = new _location();
    private DeviceLocationListener locationListener;

    public LocationProperties(@NonNull Context context) {
        super(context);
        this.locationListener = new DeviceLocationListener(context);
    }

    @Override
    public void reset() {
    }

    @Override
    public void retrieve(Retriever.PropertyCallback callback) {
        Location cellLocation;
        GeoLocation geo;
        LocationManager locationManager = (LocationManager)this.ctx.getSystemService("location");
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
            if (locationManager.isProviderEnabled("gps")) {
                Location gpsLocation = locationManager.getLastKnownLocation("gps");
                if (gpsLocation != null) {
                    ((_location)this.location).gps_location.gps_latitude = String.format("%.6f", gpsLocation.getLatitude());
                    ((_location)this.location).gps_location.gps_longitude = String.format("%.6f", gpsLocation.getLongitude());
                    ((_location)this.location).gps_location.gps_altitude = String.format("%f", gpsLocation.getAltitude());
                    ((_location)this.location).gps_location.gps_accuracy = String.format("%f", Float.valueOf(gpsLocation.getAccuracy()));
                    geo = this.getAddressFromLocation(gpsLocation);
                    ((_location)this.location).gps_location.gps_address = geo.address;
                    ((_location)this.location).gps_location.gps_country = geo.country;
                    ((_location)this.location).gps_location.gps_country_code = geo.country_code;
                    ((_location)this.location).gps_location.gps_time = geo.time;
                } else {
                    Log.w((String)TAG, (String)"last known location (gps) is null");
                }
            }
            if (locationManager.isProviderEnabled("network")) {
                cellLocation = locationManager.getLastKnownLocation("network");
                if (cellLocation != null) {
                    ((_location)this.location).cell_location.cell_latitude = String.format("%.6f", cellLocation.getLatitude());
                    ((_location)this.location).cell_location.cell_longitude = String.format("%.6f", cellLocation.getLongitude());
                    ((_location)this.location).cell_location.cell_altitude = String.format("%f", cellLocation.getAltitude());
                    ((_location)this.location).cell_location.cell_accuracy = String.format("%f", Float.valueOf(cellLocation.getAccuracy()));
                    geo = this.getAddressFromLocation(cellLocation);
                    ((_location)this.location).cell_location.cell_address = geo.address;
                    ((_location)this.location).cell_location.cell_country = geo.country;
                    ((_location)this.location).cell_location.cell_country_code = geo.country_code;
                    ((_location)this.location).cell_location.cell_time = geo.time;
                } else {
                    Log.w((String)TAG, (String)"last known location (network) is null");
                }
            }
        } else if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 && locationManager.isProviderEnabled("network")) {
            cellLocation = locationManager.getLastKnownLocation("network");
            if (cellLocation != null) {
                ((_location)this.location).cell_location.cell_latitude = String.format("%.6f", cellLocation.getLatitude());
                ((_location)this.location).cell_location.cell_longitude = String.format("%.6f", cellLocation.getLongitude());
                ((_location)this.location).cell_location.cell_altitude = String.format("%f", cellLocation.getAltitude());
                ((_location)this.location).cell_location.cell_accuracy = String.format("%f", Float.valueOf(cellLocation.getAccuracy()));
                geo = this.getAddressFromLocation(cellLocation);
                ((_location)this.location).cell_location.cell_address = geo.address;
                ((_location)this.location).cell_location.cell_country = geo.country;
                ((_location)this.location).cell_location.cell_country_code = geo.country_code;
                ((_location)this.location).cell_location.cell_time = geo.time;
            } else {
                Log.w((String)TAG, (String)"last known location (network) is null");
            }
        }
        if (Settings.Secure.getString((ContentResolver)this.ctx.getContentResolver(), (String)"mock_location").equals("0")) {
            this.location.allow_mock_location = "false";
        } else {
            this.location.allow_mock_location = "true";
        }
        int count = 0;
        PackageManager pm = this.ctx.getPackageManager();
        List packages = pm.getInstalledApplications(128);
        for (ApplicationInfo applicationInfo : packages) {
            try {
                PackageInfo packageInfo = pm.getPackageInfo(applicationInfo.packageName, 4096);
                String[] requestedPermissions = packageInfo.requestedPermissions;
                if (requestedPermissions == null) continue;
                for (int i = 0; i < requestedPermissions.length; ++i) {
                    if (!requestedPermissions[i].equals("android.permission.ACCESS_MOCK_LOCATION") || applicationInfo.packageName.equals(this.ctx.getPackageName())) continue;
                    ++count;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.location.mock_location_app_count = String.valueOf(count);
        callback.onComplete(this.location);
    }

    private GeoLocation getAddressFromLocation(Location location) {
        Geocoder geocoder = new Geocoder(this.ctx, Locale.getDefault());
        GeoLocation geo = new GeoLocation();
        try {
            List addressList = geocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
            if (addressList.size() > 0) {
                Address address = (Address)addressList.get(0);
                int addressLines = address.getMaxAddressLineIndex();
                if (addressLines != -1) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i <= addressLines; ++i) {
                        sb.append(address.getAddressLine(i));
                        if (i == addressLines) continue;
                        sb.append(",");
                    }
                    geo.address = sb.toString().replace("null", "");
                }
                geo.country_code = String.valueOf(address.getCountryCode());
                geo.country = address.getCountryName();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                geo.time = format.format(new Date(location.getTime()));
            } else {
                Log.w((String)TAG, (String)"no address matches found or no backend service available");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return geo;
    }

    @Override
    public void checkUnGrantedPermission() {
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            this.ungrantedPermissions.add("android.permission.ACCESS_COARSE_LOCATION");
        }
        if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            this.ungrantedPermissions.add("android.permission.ACCESS_FINE_LOCATION");
        }
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        String json = gson.toJson((Object)this.location);
        return json;
    }

    public class GeoLocation {
        String country_code;
        String country;
        String address;
        String time;

        public String getCountry_code() {
            return this.country_code;
        }

        public String getCountry() {
            return this.country;
        }

        public String getAddress() {
            return this.address;
        }

        public String getTime() {
            return this.time;
        }
    }

    public class GPSLocation {
        String gps_latitude;
        String gps_longitude;
        String gps_altitude;
        String gps_accuracy;
        String gps_country_code;
        String gps_country;
        String gps_address;
        String gps_time;

        public String getGps_latitude() {
            return this.gps_latitude;
        }

        public String getGps_longitude() {
            return this.gps_longitude;
        }

        public String getGps_altitude() {
            return this.gps_altitude;
        }

        public String getGps_accuracy() {
            return this.gps_accuracy;
        }

        public String getGps_country_code() {
            return this.gps_country_code;
        }

        public String getGps_country() {
            return this.gps_country;
        }

        public String getGps_address() {
            return this.gps_address;
        }

        public String getGps_time() {
            return this.gps_time;
        }
    }

    public class CellLocation {
        String cell_latitude;
        String cell_longitude;
        String cell_altitude;
        String cell_accuracy;
        String cell_country_code;
        String cell_country;
        String cell_address;
        String cell_time;

        public String getCell_latitude() {
            return this.cell_latitude;
        }

        public String getCell_longitude() {
            return this.cell_longitude;
        }

        public String getCell_altitude() {
            return this.cell_altitude;
        }

        public String getCell_accuracy() {
            return this.cell_accuracy;
        }

        public String getCell_country_code() {
            return this.cell_country_code;
        }

        public String getCell_country() {
            return this.cell_country;
        }

        public String getCell_address() {
            return this.cell_address;
        }

        public String getCell_time() {
            return this.cell_time;
        }
    }

    public class _location {
        private GPSLocation gps_location;
        private CellLocation cell_location;
        private String allow_mock_location;
        private String mock_location_app_count;

        _location() {
            this.gps_location = new GPSLocation();
            this.cell_location = new CellLocation();
        }

        public GPSLocation getGps_location() {
            return this.gps_location;
        }

        public CellLocation getCell_location() {
            return this.cell_location;
        }

        public String getAllow_mock_location() {
            if (this.allow_mock_location == null || this.allow_mock_location.length() == 0) {
                return "";
            }
            return this.allow_mock_location;
        }

        public String getMock_location_app_count() {
            if (this.mock_location_app_count == null || this.mock_location_app_count.length() == 0) {
                return "";
            }
            return this.mock_location_app_count;
        }
    }
}

