/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed.data.properties;

import android.content.Context;
import android.support.annotation.NonNull;
import com.nhnent.owl.android.feed.data.properties.BaseProperties;
import com.nhnent.owl.android.feed.data.properties.Retriever;
import com.nhnent.owl.android.feed.data.properties.sources.AccountProperties;
import com.nhnent.owl.android.feed.data.properties.sources.ApplicationProperties;
import com.nhnent.owl.android.feed.data.properties.sources.DeviceProperties;
import com.nhnent.owl.android.feed.data.properties.sources.EventProperties;
import com.nhnent.owl.android.feed.data.properties.sources.LocationProperties;
import com.nhnent.owl.android.feed.data.properties.sources.NetworkProperties;
import com.nhnent.owl.android.feed.data.properties.sources.TelephoneProperties;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DevicePrint {
    private final List<BaseProperties> properties;
    public static ApplicationProperties applicationProperties;
    private Map<String, Object> deviceMap;

    public static DevicePrint getBlackbox(@NonNull Context context) {
        return DevicePrint.getBlackbox(context, false);
    }

    public static DevicePrint getBlackbox(@NonNull Context context, boolean ignoreUnGrantedPermission) {
        applicationProperties = new ApplicationProperties(context);
        Builder builder = new Builder().addSource(applicationProperties).addSource(new DeviceProperties(context)).addSource(new LocationProperties(context)).addSource(new NetworkProperties(context)).addSource(new AccountProperties(context)).addSource(new EventProperties(context)).addSource(new TelephoneProperties(context));
        return new DevicePrint(builder, ignoreUnGrantedPermission);
    }

    private DevicePrint(Builder builder, Boolean ignoreUnGrantedPermission) {
        this.properties = builder.getRetrievers();
        this.deviceMap = new HashMap<String, Object>();
    }

    public AccountProperties getAccountProperty() {
        for (BaseProperties property : this.properties) {
            if (!(property instanceof AccountProperties)) continue;
            return (AccountProperties)property;
        }
        return null;
    }

    public EventProperties getEventProperty() {
        for (BaseProperties property : this.properties) {
            if (!(property instanceof EventProperties)) continue;
            return (EventProperties)property;
        }
        return null;
    }

    public void reset() {
        for (BaseProperties property : this.properties) {
            property.reset();
        }
        this.deviceMap.clear();
    }

    public Map<String, Object> retrieve(String nestId, String deviceId, String appKey) {
        this.reset();
        for (BaseProperties property : this.properties) {
            property.retrieve(new Retriever.PropertyCallback(){

                @Override
                public void onComplete(Object obj) {
                    DevicePrint.this.deviceMap.put(obj.getClass().getSimpleName(), obj);
                }
            });
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String reg_date = format.format(new Date());
        this.deviceMap.put("reg_date", reg_date);
        this.deviceMap.put("nest_id", nestId);
        this.deviceMap.put("device_id", deviceId);
        this.deviceMap.put("appkey", appKey);
        this.deviceMap.put("os", "android");
        return this.deviceMap;
    }

    public static class Builder {
        private final List<BaseProperties> retrievers = new ArrayList<BaseProperties>();

        public Builder addSource(BaseProperties properties) {
            this.retrievers.add(properties);
            return this;
        }

        public List<BaseProperties> getRetrievers() {
            return this.retrievers;
        }
    }
}

