/*
 * Decompiled with CFR 0.152.
 */
package com.nhnent.owl.android.feed;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.auth0.android.jwt.JWT;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.nhnent.owl.android.feed.FeedObserver;
import com.nhnent.owl.android.feed.api.FeedCallback;
import com.nhnent.owl.android.feed.api.OwlMateApi;
import com.nhnent.owl.android.feed.data.properties.DevicePrint;
import com.nhnent.owl.android.feed.data.properties.sources.AccountProperties;
import com.nhnent.owl.android.feed.data.properties.sources.EventProperties;
import com.nhnent.owl.android.feed.data.utils.FileUtil;
import com.nhnent.owl.android.feed.encrypt.AESCipher;
import com.nhnent.owl.android.feed.encrypt.CipherHelper;
import com.nhnent.owl.android.feed.encrypt.RSACipher;
import com.nhnent.owl.android.feed.listener.MainActivityEventListener;
import com.nhnent.owl.android.feed.persistent.SharedPreferencesStore;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Feeds {
    public static final String TAG = "Feed." + Feeds.class.getSimpleName();
    private static final String JWT_TOKEN = "jwt_token";
    private static final String RSA_PUBLIC_KEY = "rsa_public_key";
    private static final String FEED_PREF_FILE = "prefs_token";
    private MainActivityEventListener mainActivityEventListener;
    private ScheduledExecutorService timerService;
    private SharedPreferencesStore preferences;
    private OwlMateApi api;
    private DevicePrint blackBox;
    private SynchronizedBooleanData backgroundDone;
    protected String deviceId = "";
    protected String appKey = "";
    protected String nestId = "";
    protected String token = "";
    protected String publicKey = "";
    private Context context;
    private static final long TIMER_INIT_DELAY_IN_SECONDS = 10L;
    private static final long TIMER_DELAY_IN_SECONDS = 60L;

    Feeds() {
    }

    public static Feeds sharedInstance() {
        return SingletonHolder.instance;
    }

    public Feeds simpleInit(Activity activity, String appKey) {
        boolean apiSupportsLifecycleCallbacks;
        boolean bl = apiSupportsLifecycleCallbacks = Build.VERSION.SDK_INT >= 14;
        if (apiSupportsLifecycleCallbacks) {
            this.mainActivityEventListener = new MainActivityEventListener(activity, appKey);
            this.mainActivityEventListener.resolve();
            Feeds sdk = Feeds.sharedInstance().init(activity.getApplicationContext(), appKey);
            return sdk;
        }
        throw new IllegalStateException("You can't use automatedInit with Android SDK version <= 13 (ICE_CREAM_SANDWICH)");
    }

    private synchronized Feeds init(Context context, String appKey) {
        if (context == null) {
            throw new IllegalArgumentException("valid context is required");
        }
        if (appKey == null || appKey.length() == 0) {
            throw new IllegalArgumentException("valid appKey is required");
        }
        this.context = context;
        this.appKey = appKey;
        this.preferences = new SharedPreferencesStore(context, FEED_PREF_FILE, false);
        this.api = OwlMateApi.getInstance(context);
        this.deviceId = FeedObserver.getDeviceId(context);
        this.nestId = FeedObserver.getNestId(context);
        this.blackBox = DevicePrint.getBlackbox(context);
        this.mainActivityEventListener.addListener(DevicePrint.applicationProperties);
        this.backgroundDone = new SynchronizedBooleanData(false);
        this.timerService = Executors.newSingleThreadScheduledExecutor();
        this.timerService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (Feeds.this.mainActivityEventListener.isBackground() && !Feeds.this.backgroundDone.getVal()) {
                    Feeds.this.processFeed();
                    Feeds.this.backgroundDone.setVal(true);
                    return;
                }
                if (Feeds.this.mainActivityEventListener.isForeground()) {
                    Feeds.this.onTimer();
                    Feeds.this.backgroundDone.setVal(false);
                }
            }
        }, 10L, 60L, TimeUnit.SECONDS);
        return this;
    }

    public void setUserId(String userId) {
        AccountProperties account = this.blackBox.getAccountProperty();
        if (account != null) {
            account.setUserId(userId);
        }
    }

    public void loginEvent(final String loginSeq) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EventProperties property = Feeds.this.blackBox.getEventProperty();
                if (property != null) {
                    EventProperties._event _event2 = property.event;
                    synchronized (_event2) {
                        property.event.reset();
                        property.event.setKind("login");
                        property.event.setLogin_seq_num(loginSeq);
                        Feeds.this.processFeed();
                    }
                }
            }
        }).start();
    }

    public void transactionEvent(final String transSeq, final String orderSeq, final String mileSeq) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EventProperties property = Feeds.this.blackBox.getEventProperty();
                if (property != null) {
                    EventProperties._event _event2 = property.event;
                    synchronized (_event2) {
                        property.event.reset();
                        property.event.setKind("transaction");
                        property.event.setTrans_seq_num(transSeq);
                        property.event.setOrder_seq_num(orderSeq);
                        property.event.setMilg_seq_num(mileSeq);
                        Feeds.this.processFeed();
                    }
                }
            }
        }).start();
    }

    public void mileageEvent(final String milgSeq) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EventProperties property = Feeds.this.blackBox.getEventProperty();
                if (property != null) {
                    EventProperties._event _event2 = property.event;
                    synchronized (_event2) {
                        property.event.reset();
                        property.event.setKind("mileage");
                        property.event.setMilg_seq_num(milgSeq);
                        Feeds.this.processFeed();
                    }
                }
            }
        }).start();
    }

    public void remitEvent(final String sndmSeq) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EventProperties property = Feeds.this.blackBox.getEventProperty();
                if (property != null) {
                    EventProperties._event _event2 = property.event;
                    synchronized (_event2) {
                        property.event.reset();
                        property.event.setKind("remit");
                        property.event.setSndm_seq_num(sndmSeq);
                        Feeds.this.processFeed();
                    }
                }
            }
        }).start();
    }

    public synchronized void onStart() {
        Log.d((String)TAG, (String)"onStart");
        this.requestHissToken();
    }

    public synchronized void onStop() {
        if (this.mainActivityEventListener.getActivityCount() == 0) {
            this.processFeed();
            this.backgroundDone.setVal(true);
        }
    }

    protected synchronized void onTimer() {
        this.processFeed();
    }

    private boolean isInvalidToken() {
        if (this.token.length() == 0) {
            this.token = this.preferences.get(JWT_TOKEN);
            if (!this.preferences.contains(JWT_TOKEN) || TextUtils.isEmpty((CharSequence)this.preferences.get(JWT_TOKEN))) {
                return true;
            }
        }
        return false;
    }

    private boolean isExpiredToken() {
        if (this.token.length() == 0) {
            return false;
        }
        try {
            JWT jwt = new JWT(this.token);
            if (jwt.isExpired(0L)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    private void sendBlackBox() {
        Map<String, Object> info = this.blackBox.retrieve(this.nestId, this.deviceId, this.appKey);
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        String plainText = gson.toJson(info);
        this.sendHootMessage(plainText);
        this.blackBox.reset();
        FileUtil.write(this.context, "hoot.json", plainText);
    }

    private synchronized void processFeed() {
        if (this.isInvalidToken()) {
            Log.w((String)TAG, (String)"token does not exist!!");
            this.requestAuthToken(new FeedCallback(){

                @Override
                public void onSuccess(JsonArray result) {
                    Feeds.this.sendBlackBox();
                }

                @Override
                public void onError(String errorType, List<String> error) {
                }
            });
        } else if (this.isExpiredToken()) {
            Log.d((String)TAG, (String)"token is expired");
            this.requestAuthToken(new FeedCallback(){

                @Override
                public void onSuccess(JsonArray result) {
                    Feeds.this.sendBlackBox();
                }

                @Override
                public void onError(String errorType, List<String> error) {
                }
            });
        } else {
            this.sendBlackBox();
        }
    }

    private void requestAuthToken(final FeedCallback callback) {
        Log.d((String)TAG, (String)"requestAuthToken");
        JsonObject payload = new JsonObject();
        payload.addProperty("appkey", this.appKey);
        payload.addProperty("nestId", this.nestId);
        payload.addProperty("os", "android");
        payload.addProperty("deviceId", this.deviceId);
        String message = this.getRequestBodyMessage(payload.toString(), false);
        if (message.length() == 0) {
            Log.w((String)TAG, (String)"Failed to get body message");
            return;
        }
        OwlMateApi.auth(message, new FeedCallback(){

            @Override
            public void onSuccess(JsonArray result) {
                try {
                    JsonObject response = result.get(0).getAsJsonObject();
                    if (response.get("status").getAsString().equalsIgnoreCase("OK")) {
                        Feeds.this.token = response.get("message").getAsString();
                        Feeds.this.preferences.put(Feeds.JWT_TOKEN, Feeds.this.token);
                        if (Feeds.this.token.length() > 0) {
                            JWT jwt = new JWT(Feeds.this.token);
                            Feeds.this.nestId = jwt.getClaim("nestId").asString();
                            if (Feeds.this.nestId.length() > 0) {
                                FeedObserver.setNestId(Feeds.this.context, Feeds.this.nestId);
                            }
                        }
                    } else {
                        Log.w((String)TAG, (String)(response.get("status").getAsString() + " , " + response.get("message").getAsString()));
                    }
                    callback.onSuccess(result);
                }
                catch (JsonIOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(String errorType, List<String> error) {
                Log.e((String)TAG, (String)("requestAuthToken- onError : " + error.toString()));
            }
        });
    }

    private void sendHootMessage(String plainText) {
        Log.d((String)TAG, (String)"sendHootMessage");
        String message = this.getRequestBodyMessage(plainText, true);
        OwlMateApi.hoot(message, this.token, new FeedCallback(){

            @Override
            public void onSuccess(JsonArray result) {
                try {
                    JsonObject response = result.get(0).getAsJsonObject();
                    if (response.get("status").getAsString().equalsIgnoreCase("OK")) {
                        Log.d((String)TAG, (String)response.get("message").getAsString());
                    } else {
                        Log.e((String)TAG, (String)(response.get("status").getAsString() + " , " + response.get("code").getAsString() + ", " + response.get("message").getAsString()));
                    }
                }
                catch (JsonIOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(String errorType, List<String> error) {
                Log.e((String)TAG, (String)("sendHootMessage- onError : " + error.toString()));
            }
        });
    }

    private void requestHissToken() {
        Log.d((String)TAG, (String)"requestHissToken");
        OwlMateApi.hiss(new FeedCallback(){

            @Override
            public void onSuccess(JsonArray result) {
                try {
                    JsonObject response = result.get(0).getAsJsonObject();
                    if (response.get("status").getAsString().equalsIgnoreCase("OK")) {
                        Feeds.this.publicKey = response.get("message").getAsString();
                        Feeds.this.preferences.put(Feeds.RSA_PUBLIC_KEY, Feeds.this.publicKey);
                        Log.d((String)TAG, (String)Feeds.this.publicKey);
                    } else {
                        Log.w((String)TAG, (String)(response.get("status").getAsString() + " , " + response.get("message").getAsString()));
                    }
                }
                catch (JsonIOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(String errorType, List<String> error) {
                Log.e((String)TAG, (String)("requestHissToken- onError : " + error.toString()));
            }
        });
    }

    private String getRequestBodyMessage(String plainData, Boolean isCompress) {
        try {
            byte[] aesKey = AESCipher.generateAESKey();
            byte[] iv = AESCipher.getIV();
            String encryptBody = CipherHelper.encrypt(plainData.toString(), aesKey, iv, isCompress);
            if (this.publicKey.length() <= 0) {
                if (!this.preferences.contains(RSA_PUBLIC_KEY) || TextUtils.isEmpty((CharSequence)this.preferences.get(RSA_PUBLIC_KEY))) {
                    this.requestHissToken();
                    return "";
                }
                this.publicKey = this.preferences.get(RSA_PUBLIC_KEY);
            }
            PublicKey rsaKey = RSACipher.getPublicKey(this.publicKey);
            String encryptKey = RSACipher.encryptWithBase64(aesKey, rsaKey);
            String base64Iv = Base64.encodeToString((byte[])iv, (int)2);
            return encryptBody + "|" + encryptKey + "|" + base64Iv;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    protected class SynchronizedBooleanData {
        private boolean val;

        public SynchronizedBooleanData(boolean val) {
            this.val = val;
        }

        public synchronized void setVal(boolean val) {
            this.val = val;
        }

        public synchronized boolean getVal() {
            return this.val;
        }
    }

    private static class SingletonHolder {
        static final Feeds instance = new Feeds();

        private SingletonHolder() {
        }
    }
}

