/*
 * Decompiled with CFR 0.152.
 */
package com.pavelsikun.seekbarpreference;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceViewHolder;
import android.util.AttributeSet;
import android.view.View;
import com.pavelsikun.seekbarpreference.ChangeValueListener;
import com.pavelsikun.seekbarpreference.PersistValueListener;
import com.pavelsikun.seekbarpreference.PreferenceControllerDelegate;
import com.pavelsikun.seekbarpreference.R;

public class SeekBarPreferenceCompat
extends Preference
implements View.OnClickListener,
PreferenceControllerDelegate.ViewStateListener,
PersistValueListener,
ChangeValueListener {
    private PreferenceControllerDelegate controllerDelegate;

    @TargetApi(value=21)
    public SeekBarPreferenceCompat(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    public SeekBarPreferenceCompat(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public SeekBarPreferenceCompat(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public SeekBarPreferenceCompat(Context context) {
        super(context);
        this.init(null);
    }

    private void init(AttributeSet attrs) {
        this.setLayoutResource(R.layout.seekbar_view_layout);
        this.controllerDelegate = new PreferenceControllerDelegate(this.getContext(), false);
        this.controllerDelegate.setViewStateListener(this);
        this.controllerDelegate.setPersistValueListener(this);
        this.controllerDelegate.setChangeValueListener(this);
        this.controllerDelegate.loadValuesFromXml(attrs);
    }

    public void onBindViewHolder(PreferenceViewHolder viewRoot) {
        super.onBindViewHolder(viewRoot);
        this.controllerDelegate.onBind(viewRoot.itemView);
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
        super.onSetInitialValue(restorePersistedValue, defaultValue);
        this.controllerDelegate.setCurrentValue(this.getPersistedInt(this.controllerDelegate.getCurrentValue()));
    }

    @Override
    public boolean persistInt(int value) {
        return super.persistInt(value);
    }

    @Override
    public boolean onChange(int value) {
        return this.callChangeListener(value);
    }

    public void onClick(View v) {
        this.controllerDelegate.onClick(v);
    }

    public int getMaxValue() {
        return this.controllerDelegate.getMaxValue();
    }

    public void setMaxValue(int maxValue) {
        this.controllerDelegate.setMaxValue(maxValue);
    }

    public int getMinValue() {
        return this.controllerDelegate.getMinValue();
    }

    public void setMinValue(int minValue) {
        this.controllerDelegate.setMinValue(minValue);
    }

    public int getInterval() {
        return this.controllerDelegate.getInterval();
    }

    public void setInterval(int interval) {
        this.controllerDelegate.setInterval(interval);
    }

    public int getCurrentValue() {
        return this.controllerDelegate.getCurrentValue();
    }

    public void setCurrentValue(int currentValue) {
        this.controllerDelegate.setCurrentValue(currentValue);
        this.persistInt(this.controllerDelegate.getCurrentValue());
    }

    public String getMeasurementUnit() {
        return this.controllerDelegate.getMeasurementUnit();
    }

    public void setMeasurementUnit(String measurementUnit) {
        this.controllerDelegate.setMeasurementUnit(measurementUnit);
    }

    public boolean isDialogEnabled() {
        return this.controllerDelegate.isDialogEnabled();
    }

    public void setDialogEnabled(boolean dialogEnabled) {
        this.controllerDelegate.setDialogEnabled(dialogEnabled);
    }

    public void setDialogStyle(int dialogStyle) {
        this.controllerDelegate.setDialogStyle(dialogStyle);
    }
}

