/*
 * Decompiled with CFR 0.152.
 */
package com.pavelsikun.seekbarpreference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.pavelsikun.seekbarpreference.ChangeValueListener;
import com.pavelsikun.seekbarpreference.CustomValueDialog;
import com.pavelsikun.seekbarpreference.PersistValueListener;
import com.pavelsikun.seekbarpreference.R;

class PreferenceControllerDelegate
implements SeekBar.OnSeekBarChangeListener,
View.OnClickListener {
    private final String TAG = this.getClass().getSimpleName();
    private static final int DEFAULT_CURRENT_VALUE = 50;
    private static final int DEFAULT_MIN_VALUE = 0;
    private static final int DEFAULT_MAX_VALUE = 100;
    private static final int DEFAULT_INTERVAL = 1;
    private static final boolean DEFAULT_DIALOG_ENABLED = true;
    private static final boolean DEFAULT_IS_ENABLED = true;
    private static final int DEFAULT_DIALOG_STYLE = R.style.MSB_Dialog_Default;
    private int maxValue;
    private int minValue;
    private int interval;
    private int currentValue;
    private String measurementUnit;
    private boolean dialogEnabled;
    private int dialogStyle;
    private TextView valueView;
    private SeekBar seekBarView;
    private TextView measurementView;
    private LinearLayout valueHolderView;
    private FrameLayout bottomLineView;
    private TextView titleView;
    private TextView summaryView;
    private String title;
    private String summary;
    private boolean isEnabled;
    private boolean isView = false;
    private Context context;
    private ViewStateListener viewStateListener;
    private PersistValueListener persistValueListener;
    private ChangeValueListener changeValueListener;

    PreferenceControllerDelegate(Context context, Boolean isView) {
        this.context = context;
        this.isView = isView;
    }

    void setPersistValueListener(PersistValueListener persistValueListener) {
        this.persistValueListener = persistValueListener;
    }

    void setViewStateListener(ViewStateListener viewStateListener) {
        this.viewStateListener = viewStateListener;
    }

    void setChangeValueListener(ChangeValueListener changeValueListener) {
        this.changeValueListener = changeValueListener;
    }

    void loadValuesFromXml(AttributeSet attrs) {
        if (attrs == null) {
            this.currentValue = 50;
            this.minValue = 0;
            this.maxValue = 100;
            this.interval = 1;
            this.dialogEnabled = true;
            this.isEnabled = true;
        } else {
            TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.SeekBarPreference);
            try {
                this.minValue = a.getInt(R.styleable.SeekBarPreference_msbp_minValue, 0);
                this.maxValue = a.getInt(R.styleable.SeekBarPreference_msbp_maxValue, 100);
                this.interval = a.getInt(R.styleable.SeekBarPreference_msbp_interval, 1);
                this.dialogEnabled = a.getBoolean(R.styleable.SeekBarPreference_msbp_dialogEnabled, true);
                this.measurementUnit = a.getString(R.styleable.SeekBarPreference_msbp_measurementUnit);
                this.currentValue = attrs.getAttributeIntValue("http://schemas.android.com/apk/res/android", "defaultValue", 50);
                this.dialogStyle = DEFAULT_DIALOG_STYLE;
                if (this.isView) {
                    this.title = a.getString(R.styleable.SeekBarPreference_msbp_view_title);
                    this.summary = a.getString(R.styleable.SeekBarPreference_msbp_view_summary);
                    this.currentValue = a.getInt(R.styleable.SeekBarPreference_msbp_view_defaultValue, 50);
                    this.isEnabled = a.getBoolean(R.styleable.SeekBarPreference_msbp_view_enabled, true);
                }
            }
            finally {
                a.recycle();
            }
        }
    }

    void onBind(View view) {
        if (this.isView) {
            this.titleView = (TextView)view.findViewById(16908310);
            this.summaryView = (TextView)view.findViewById(0x1020010);
            this.titleView.setText((CharSequence)this.title);
            this.summaryView.setText((CharSequence)this.summary);
        }
        view.setClickable(false);
        this.seekBarView = (SeekBar)view.findViewById(R.id.seekbar);
        this.measurementView = (TextView)view.findViewById(R.id.measurement_unit);
        this.valueView = (TextView)view.findViewById(R.id.seekbar_value);
        this.setMaxValue(this.maxValue);
        this.seekBarView.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.seekBarView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int action = event.getAction();
                switch (action) {
                    case 0: {
                        v.getParent().requestDisallowInterceptTouchEvent(true);
                        break;
                    }
                    case 1: {
                        v.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                }
                v.onTouchEvent(event);
                return true;
            }
        });
        this.measurementView.setText((CharSequence)this.measurementUnit);
        this.setCurrentValue(this.currentValue);
        this.valueView.setText((CharSequence)String.valueOf(this.currentValue));
        this.bottomLineView = (FrameLayout)view.findViewById(R.id.bottom_line);
        this.valueHolderView = (LinearLayout)view.findViewById(R.id.value_holder);
        this.setDialogEnabled(this.dialogEnabled);
        this.setEnabled(this.isEnabled());
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        int newValue = progress + this.minValue;
        if (this.interval != 1 && newValue % this.interval != 0) {
            newValue = Math.round((float)newValue / (float)this.interval) * this.interval;
        }
        if (newValue > this.maxValue) {
            newValue = this.maxValue;
        } else if (newValue < this.minValue) {
            newValue = this.minValue;
        }
        if (this.changeValueListener != null && !this.changeValueListener.onChange(newValue)) {
            return;
        }
        this.currentValue = newValue;
        this.valueView.setText((CharSequence)String.valueOf(newValue));
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        this.setCurrentValue(this.currentValue);
    }

    public void onClick(View v) {
        new CustomValueDialog(this.context, this.dialogStyle, this.minValue, this.maxValue, this.currentValue).setPersistValueListener(new PersistValueListener(){

            @Override
            public boolean persistInt(int value) {
                PreferenceControllerDelegate.this.setCurrentValue(value);
                PreferenceControllerDelegate.this.seekBarView.setOnSeekBarChangeListener(null);
                PreferenceControllerDelegate.this.seekBarView.setProgress(PreferenceControllerDelegate.this.currentValue - PreferenceControllerDelegate.this.minValue);
                PreferenceControllerDelegate.this.seekBarView.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)PreferenceControllerDelegate.this);
                PreferenceControllerDelegate.this.valueView.setText((CharSequence)String.valueOf(PreferenceControllerDelegate.this.currentValue));
                return true;
            }
        }).show();
    }

    String getTitle() {
        return this.title;
    }

    void setTitle(String title) {
        this.title = title;
        if (this.titleView != null) {
            this.titleView.setText((CharSequence)title);
        }
    }

    String getSummary() {
        return this.summary;
    }

    void setSummary(String summary) {
        this.summary = summary;
        if (this.seekBarView != null) {
            this.summaryView.setText((CharSequence)summary);
        }
    }

    boolean isEnabled() {
        if (!this.isView && this.viewStateListener != null) {
            return this.viewStateListener.isEnabled();
        }
        return this.isEnabled;
    }

    void setEnabled(boolean enabled) {
        Log.d((String)this.TAG, (String)("setEnabled = " + enabled));
        this.isEnabled = enabled;
        if (this.viewStateListener != null) {
            this.viewStateListener.setEnabled(enabled);
        }
        if (this.seekBarView != null) {
            Log.d((String)this.TAG, (String)"view is disabled!");
            this.seekBarView.setEnabled(enabled);
            this.valueView.setEnabled(enabled);
            this.valueHolderView.setClickable(enabled);
            this.valueHolderView.setEnabled(enabled);
            this.measurementView.setEnabled(enabled);
            this.bottomLineView.setEnabled(enabled);
            if (this.isView) {
                this.titleView.setEnabled(enabled);
                this.summaryView.setEnabled(enabled);
            }
        }
    }

    int getMaxValue() {
        return this.maxValue;
    }

    void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        if (this.seekBarView != null) {
            if (this.minValue <= 0 && maxValue >= 0) {
                this.seekBarView.setMax(maxValue - this.minValue);
            } else {
                this.seekBarView.setMax(maxValue);
            }
            this.seekBarView.setProgress(this.currentValue - this.minValue);
        }
    }

    int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
        this.setMaxValue(this.maxValue);
    }

    int getInterval() {
        return this.interval;
    }

    void setInterval(int interval) {
        this.interval = interval;
    }

    int getCurrentValue() {
        return this.currentValue;
    }

    void setCurrentValue(int value) {
        if (value < this.minValue) {
            value = this.minValue;
        }
        if (value > this.maxValue) {
            value = this.maxValue;
        }
        if (this.changeValueListener != null && !this.changeValueListener.onChange(value)) {
            return;
        }
        this.currentValue = value;
        if (this.persistValueListener != null) {
            this.persistValueListener.persistInt(value);
        }
    }

    String getMeasurementUnit() {
        return this.measurementUnit;
    }

    void setMeasurementUnit(String measurementUnit) {
        this.measurementUnit = measurementUnit;
        if (this.measurementView != null) {
            this.measurementView.setText((CharSequence)measurementUnit);
        }
    }

    boolean isDialogEnabled() {
        return this.dialogEnabled;
    }

    void setDialogEnabled(boolean dialogEnabled) {
        this.dialogEnabled = dialogEnabled;
        if (this.valueHolderView != null && this.bottomLineView != null) {
            this.valueHolderView.setOnClickListener((View.OnClickListener)(dialogEnabled ? this : null));
            this.valueHolderView.setClickable(dialogEnabled);
            this.bottomLineView.setVisibility(dialogEnabled ? 0 : 4);
        }
    }

    void setDialogStyle(int dialogStyle) {
        this.dialogStyle = dialogStyle;
    }

    static interface ViewStateListener {
        public boolean isEnabled();

        public void setEnabled(boolean var1);
    }
}

