/*
 * Decompiled with CFR 0.152.
 */
package com.nfx.android.rangebarpreference;

import android.content.Context;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceViewHolder;
import android.util.AttributeSet;
import com.nfx.android.rangebarpreference.ChangeValueListener;
import com.nfx.android.rangebarpreference.PersistValueListener;
import com.nfx.android.rangebarpreference.PreferenceControllerDelegate;
import com.nfx.android.rangebarpreference.R;
import com.nfx.android.rangebarpreference.RangeBarHelper;

public class RangeBarPreferenceCompat
extends Preference
implements PreferenceControllerDelegate.ViewStateListener,
ChangeValueListener,
PersistValueListener {
    private PreferenceControllerDelegate controllerDelegate;

    public RangeBarPreferenceCompat(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    public RangeBarPreferenceCompat(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public RangeBarPreferenceCompat(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public RangeBarPreferenceCompat(Context context) {
        super(context);
        this.init(null);
    }

    private void init(AttributeSet attrs) {
        this.setLayoutResource(R.layout.range_bar_view_layout);
        this.controllerDelegate = new PreferenceControllerDelegate(this.getContext());
        this.controllerDelegate.setViewStateListener(this);
        this.controllerDelegate.setPersistValueListener(this);
        this.controllerDelegate.setChangeValueListener(this);
        this.controllerDelegate.loadValuesFromXml(attrs);
    }

    public void onBindViewHolder(PreferenceViewHolder viewRoot) {
        super.onBindViewHolder(viewRoot);
        this.controllerDelegate.onBind(viewRoot.itemView);
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
        super.onSetInitialValue(restorePersistedValue, defaultValue);
        String jsonString = RangeBarHelper.convertValuesToJsonString(this.controllerDelegate.getCurrentLowValue(), this.controllerDelegate.getCurrentHighValue());
        this.controllerDelegate.setValues(this.getPersistedString(jsonString));
        this.controllerDelegate.persistValues();
    }

    @Override
    public boolean persistString(String value) {
        return super.persistString(value);
    }

    @Override
    public boolean onChangeValue(String jsonString) {
        return this.callChangeListener(jsonString);
    }

    public float getTickEnd() {
        return this.controllerDelegate.getTickEnd();
    }

    public void setTickEnd(float tickEnd) {
        this.controllerDelegate.setTickEnd(tickEnd);
    }

    public float getTickStart() {
        return this.controllerDelegate.getTickStart();
    }

    public void setTickStart(int tickStart) {
        this.controllerDelegate.setTickStart(tickStart);
    }

    public float getTickInterval() {
        return this.controllerDelegate.getTickInterval();
    }

    public void setTickInterval(int tickInterval) {
        this.controllerDelegate.setTickInterval(tickInterval);
    }

    public float getCurrentLowValue() {
        return this.controllerDelegate.getCurrentLowValue();
    }

    public void setCurrentLowValue(float currentLowValue) {
        this.controllerDelegate.setCurrentLowValue(currentLowValue);
    }

    public float getCurrentHighValue() {
        return this.controllerDelegate.getCurrentHighValue();
    }

    public void setCurrentHighValue(float currentHighValue) {
        this.controllerDelegate.setCurrentHighValue(currentHighValue);
    }

    public String getMeasurementUnit() {
        return this.controllerDelegate.getMeasurementUnit();
    }

    public void setMeasurementUnit(String measurementUnit) {
        this.controllerDelegate.setMeasurementUnit(measurementUnit);
    }

    public boolean isDialogEnabled() {
        return this.controllerDelegate.isDialogEnabled();
    }

    public void setDialogEnabled(boolean dialogEnabled) {
        this.controllerDelegate.setDialogEnabled(dialogEnabled);
    }

    public void setDialogStyle(int dialogStyle) {
        this.controllerDelegate.setDialogStyle(dialogStyle);
    }
}

