/*
 * Decompiled with CFR 0.152.
 */
package com.nfx.android.rangebarpreference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.appyvet.rangebar.RangeBar;
import com.nfx.android.rangebarpreference.ChangeValueListener;
import com.nfx.android.rangebarpreference.CustomValueDialog;
import com.nfx.android.rangebarpreference.CustomValueDialogListener;
import com.nfx.android.rangebarpreference.PersistValueListener;
import com.nfx.android.rangebarpreference.PreferencePinFormatterText;
import com.nfx.android.rangebarpreference.R;
import com.nfx.android.rangebarpreference.RangeBarHelper;
import com.nfx.android.rangebarpreference.RangeBarValueJSON;
import org.json.JSONException;

class PreferenceControllerDelegate
implements RangeBar.OnRangeBarChangeListener,
View.OnTouchListener {
    private static final float DEFAULT_CURRENT_LOW_VALUE = 20.0f;
    private static final float DEFAULT_CURRENT_HIGH_VALUE = 80.0f;
    private static final float DEFAULT_TICK_START = 0.0f;
    private static final float DEFAULT_TICK_END = 100.0f;
    private static final float DEFAULT_TICK_INTERVAL = 1.0f;
    private static final boolean DEFAULT_DIALOG_ENABLED = true;
    private static final boolean DEFAULT_IS_ENABLED = true;
    private static final int DEFAULT_DIALOG_STYLE = R.style.Range_Bar_Dialog_Default;
    private final Context context;
    private String measurementUnit;
    private boolean dialogEnabled = true;
    private int dialogStyle;
    private TextView currentLowValueView;
    private TextView currentLowMeasurementView;
    private FrameLayout currentLowBottomLineView;
    private LinearLayout lowValueHolderView;
    private TextView currentHighValueView;
    private TextView currentHighMeasurementView;
    private FrameLayout currentHighBottomLineView;
    private LinearLayout highValueHolderView;
    private RangeBar rangeBarView;
    private boolean isEnabled = true;
    private float currentLowValue = 20.0f;
    private float currentHighValue = 80.0f;
    private float tempLowValue = 20.0f;
    private float tempHighValue = 80.0f;
    private float tickStart = 0.0f;
    private float tickEnd = 100.0f;
    private float tickInterval = 1.0f;
    private ViewStateListener viewStateListener;
    private PersistValueListener persistValueListener;
    private ChangeValueListener changeValueListener;
    private final View.OnClickListener currentLowValueClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            new CustomValueDialog(PreferenceControllerDelegate.this.context, PreferenceControllerDelegate.this.dialogStyle, PreferenceControllerDelegate.this.getTickStart(), PreferenceControllerDelegate.this.getTickEnd(), PreferenceControllerDelegate.this.getCurrentLowValue()).setOnChangeListener(new CustomValueDialogListener(){

                @Override
                public void onChangeValue(float value) {
                    PreferenceControllerDelegate.this.setLocalLowValue(value);
                    PreferenceControllerDelegate.this.persistValues();
                    PreferenceControllerDelegate.this.rangeBarView.setOnRangeBarChangeListener(null);
                    PreferenceControllerDelegate.this.rangeBarView.setRangePinsByValue(PreferenceControllerDelegate.this.currentLowValue, PreferenceControllerDelegate.this.currentHighValue);
                    PreferenceControllerDelegate.this.rangeBarView.setOnRangeBarChangeListener((RangeBar.OnRangeBarChangeListener)PreferenceControllerDelegate.this);
                }
            }).show();
        }
    };
    private final View.OnClickListener currentHighValueClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            new CustomValueDialog(PreferenceControllerDelegate.this.context, PreferenceControllerDelegate.this.dialogStyle, PreferenceControllerDelegate.this.getTickStart(), PreferenceControllerDelegate.this.getTickEnd(), PreferenceControllerDelegate.this.getCurrentHighValue()).setOnChangeListener(new CustomValueDialogListener(){

                @Override
                public void onChangeValue(float value) {
                    PreferenceControllerDelegate.this.setLocalHighValue(value);
                    PreferenceControllerDelegate.this.persistValues();
                    PreferenceControllerDelegate.this.rangeBarView.setOnRangeBarChangeListener(null);
                    PreferenceControllerDelegate.this.rangeBarView.setRangePinsByValue(PreferenceControllerDelegate.this.currentLowValue, PreferenceControllerDelegate.this.currentHighValue);
                    PreferenceControllerDelegate.this.rangeBarView.setOnRangeBarChangeListener((RangeBar.OnRangeBarChangeListener)PreferenceControllerDelegate.this);
                }
            }).show();
        }
    };
    private boolean dragEvent = false;

    PreferenceControllerDelegate(Context context) {
        this.context = context;
    }

    void setPersistValueListener(PersistValueListener persistValueListener) {
        this.persistValueListener = persistValueListener;
    }

    void setViewStateListener(ViewStateListener viewStateListener) {
        this.viewStateListener = viewStateListener;
    }

    void setChangeValueListener(ChangeValueListener changeValueListener) {
        this.changeValueListener = changeValueListener;
    }

    void loadValuesFromXml(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.RangeBarPreference);
            try {
                this.tickStart = a.getFloat(R.styleable.RangeBarPreference_rbp_tickStart, 0.0f);
                this.tickEnd = a.getFloat(R.styleable.RangeBarPreference_rbp_tickEnd, 100.0f);
                this.tickInterval = a.getFloat(R.styleable.RangeBarPreference_rbp_tickInterval, 1.0f);
                this.dialogEnabled = a.getBoolean(R.styleable.RangeBarPreference_rbp_dialogEnabled, true);
                this.measurementUnit = a.getString(R.styleable.RangeBarPreference_rbp_measurementUnit);
                this.currentLowValue = a.getFloat(R.styleable.RangeBarPreference_rbp_view_defaultLowValue, 20.0f);
                this.currentHighValue = a.getFloat(R.styleable.RangeBarPreference_rbp_view_defaultHighValue, 80.0f);
                this.dialogStyle = DEFAULT_DIALOG_STYLE;
            }
            finally {
                a.recycle();
            }
        }
    }

    public void onRangeChangeListener(RangeBar rangeBar, int leftPinIndex, int rightPinIndex, String leftPinValueString, String rightPinValueString) {
        this.setLocalLowValue(Float.valueOf(leftPinValueString).floatValue());
        this.setLocalHighValue(Float.valueOf(rightPinValueString).floatValue());
        if (!this.dragEvent) {
            this.persistValues();
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (event.getAction() == 0) {
            this.dragEvent = true;
            this.tempLowValue = this.currentLowValue;
            this.tempHighValue = this.currentHighValue;
        } else if (event.getAction() == 1) {
            if (this.dragEvent) {
                this.persistValues();
            }
            this.dragEvent = false;
        }
        return false;
    }

    void onBind(View view) {
        this.rangeBarView = (RangeBar)view.findViewById(R.id.range_bar);
        this.currentLowMeasurementView = (TextView)view.findViewById(R.id.current_low_value_measurement_unit);
        this.currentLowValueView = (TextView)view.findViewById(R.id.current_low_value);
        this.currentHighMeasurementView = (TextView)view.findViewById(R.id.current_high_value_measurement_unit);
        this.currentHighValueView = (TextView)view.findViewById(R.id.current_high_value);
        this.rangeBarView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int action = event.getAction();
                switch (action) {
                    case 0: {
                        v.getParent().requestDisallowInterceptTouchEvent(true);
                        break;
                    }
                    case 1: {
                        v.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                }
                v.onTouchEvent(event);
                return true;
            }
        });
        this.rangeBarView.setPinTextFormatter((RangeBar.PinTextFormatter)new PreferencePinFormatterText());
        this.rangeBarView.setTickEnd(this.tickEnd);
        this.rangeBarView.setTickStart(this.tickStart);
        this.rangeBarView.setTickInterval(this.tickInterval);
        this.rangeBarView.setDrawTicks(false);
        this.currentLowMeasurementView.setText((CharSequence)this.measurementUnit);
        this.currentHighMeasurementView.setText((CharSequence)this.measurementUnit);
        this.setLocalLowValue(this.currentLowValue);
        this.setLocalHighValue(this.currentHighValue);
        this.rangeBarView.setRangePinsByValue(this.currentLowValue, this.currentHighValue);
        this.rangeBarView.setOnRangeBarChangeListener((RangeBar.OnRangeBarChangeListener)this);
        this.rangeBarView.setOnTouchListener((View.OnTouchListener)this);
        this.currentLowBottomLineView = (FrameLayout)view.findViewById(R.id.current_low_value_bottom_line);
        this.currentHighBottomLineView = (FrameLayout)view.findViewById(R.id.current_high_value_bottom_line);
        this.lowValueHolderView = (LinearLayout)view.findViewById(R.id.low_value_holder);
        this.highValueHolderView = (LinearLayout)view.findViewById(R.id.high_value_holder);
        this.setDialogEnabled(this.dialogEnabled);
        this.setEnabled(this.isEnabled());
    }

    boolean isEnabled() {
        if (this.viewStateListener != null) {
            return this.viewStateListener.isEnabled();
        }
        return this.isEnabled;
    }

    void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        if (this.viewStateListener != null) {
            this.viewStateListener.setEnabled(enabled);
        }
        if (this.rangeBarView != null) {
            this.rangeBarView.setEnabled(enabled);
            this.currentLowValueView.setEnabled(enabled);
            this.currentHighValueView.setEnabled(enabled);
            this.lowValueHolderView.setClickable(enabled);
            this.lowValueHolderView.setEnabled(enabled);
            this.highValueHolderView.setClickable(enabled);
            this.highValueHolderView.setEnabled(enabled);
            this.currentHighMeasurementView.setEnabled(enabled);
            this.currentLowMeasurementView.setEnabled(enabled);
            this.currentLowBottomLineView.setEnabled(enabled);
            this.currentHighBottomLineView.setEnabled(enabled);
        }
    }

    float getTickEnd() {
        return this.rangeBarView.getTickEnd();
    }

    void setTickEnd(float tickEnd) {
        this.rangeBarView.setTickEnd(tickEnd);
    }

    float getTickStart() {
        return this.rangeBarView.getTickStart();
    }

    void setTickStart(float tickStart) {
        this.rangeBarView.setTickStart(tickStart);
    }

    float getTickInterval() {
        return (float)this.rangeBarView.getTickInterval();
    }

    void setTickInterval(float interval) {
        this.rangeBarView.setTickInterval(interval);
    }

    float getCurrentLowValue() {
        return this.currentLowValue;
    }

    void setCurrentLowValue(float value) {
        this.setLocalLowValue(value);
        this.persistValues();
    }

    private void setLocalLowValue(float value) {
        float highValue;
        float lowValue;
        if (value < this.tempHighValue) {
            lowValue = value;
            highValue = this.tempHighValue;
        } else {
            lowValue = this.tempHighValue;
            highValue = value;
        }
        this.setLocalValues(lowValue, highValue);
    }

    float getCurrentHighValue() {
        return this.currentHighValue;
    }

    void setCurrentHighValue(float value) {
        this.setLocalHighValue(value);
        this.persistValues();
    }

    private void setLocalHighValue(float value) {
        float highValue;
        float lowValue;
        if (value > this.tempLowValue) {
            lowValue = this.tempLowValue;
            highValue = value;
        } else {
            lowValue = value;
            highValue = this.tempLowValue;
        }
        this.setLocalValues(lowValue, highValue);
    }

    private void setLocalValues(float lowValue, float highValue) {
        this.tempLowValue = lowValue > this.tickStart ? lowValue : this.tickStart;
        float f = this.tempHighValue = highValue < this.tickEnd ? highValue : this.tickEnd;
        if (this.currentLowValueView != null) {
            this.currentLowValueView.setText((CharSequence)RangeBarHelper.formatFloatToString(this.tempLowValue));
        }
        if (this.currentHighValueView != null) {
            this.currentHighValueView.setText((CharSequence)RangeBarHelper.formatFloatToString(this.tempHighValue));
        }
    }

    void persistValues() {
        String jsonString = RangeBarHelper.convertValuesToJsonString(this.tempLowValue, this.tempHighValue);
        if (this.changeValueListener != null && !this.changeValueListener.onChangeValue(jsonString)) {
            return;
        }
        this.currentLowValue = this.tempLowValue;
        this.currentHighValue = this.tempHighValue;
        if (this.persistValueListener != null) {
            this.persistValueListener.persistString(jsonString);
        }
    }

    void setValues(String jsonString) {
        try {
            RangeBarValueJSON rangeBarValueJSON = new RangeBarValueJSON(jsonString);
            this.setLocalHighValue(rangeBarValueJSON.getHighValue());
            this.setLocalLowValue(rangeBarValueJSON.getLowValue());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    String getMeasurementUnit() {
        return this.measurementUnit;
    }

    void setMeasurementUnit(String measurementUnit) {
        this.measurementUnit = measurementUnit;
        if (this.currentLowMeasurementView != null) {
            this.currentLowMeasurementView.setText((CharSequence)measurementUnit);
        }
        if (this.currentHighMeasurementView != null) {
            this.currentHighMeasurementView.setText((CharSequence)measurementUnit);
        }
    }

    boolean isDialogEnabled() {
        return this.dialogEnabled;
    }

    void setDialogEnabled(boolean dialogEnabled) {
        this.dialogEnabled = dialogEnabled;
        if (this.lowValueHolderView != null && this.highValueHolderView != null && this.currentLowBottomLineView != null && this.currentHighBottomLineView != null) {
            this.lowValueHolderView.setOnClickListener(dialogEnabled ? this.currentLowValueClickListener : null);
            this.lowValueHolderView.setClickable(dialogEnabled);
            this.highValueHolderView.setOnClickListener(dialogEnabled ? this.currentHighValueClickListener : null);
            this.highValueHolderView.setClickable(dialogEnabled);
            this.currentLowBottomLineView.setVisibility(dialogEnabled ? 0 : 4);
            this.currentHighBottomLineView.setVisibility(dialogEnabled ? 0 : 4);
        }
    }

    void setDialogStyle(int dialogStyle) {
        this.dialogStyle = dialogStyle;
    }

    static interface ViewStateListener {
        public boolean isEnabled();

        public void setEnabled(boolean var1);
    }
}

