/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnList;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.JumpInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.LabelNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.VarInsnNode;
import com.newrelic.weave.ClassMatch;
import com.newrelic.weave.GeneratedNewFieldMethod;
import com.newrelic.weave.MethodProcessors;
import com.newrelic.weave.utils.ReferenceUtils;
import com.newrelic.weave.utils.SynchronizedClassNode;
import com.newrelic.weave.utils.WeaveUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PreparedExtension {
    public static final String RESET_CHECK_NAME = "gen_shouldResetExtensionClass";
    public static final String RESET_CHECK_DESC = "()Z";
    private static final String EXTENSION_CLASS_FORMAT = "com/newrelic/weave/%s_%d_nr_ext";
    private static final int NO_EXTENSION_CACHE = -1;
    private final ClassMatch match;
    private final String extensionClassName;
    private final Type extensionClassType;
    private final Type originalType;
    private final ClassNode extensionTemplate;
    private final Set<String> extensionNodeFieldNames;

    public PreparedExtension(ClassMatch match, ClassNode template) {
        this.match = match;
        this.extensionClassName = String.format(EXTENSION_CLASS_FORMAT, match.getOriginal().name, System.identityHashCode(match));
        this.extensionClassType = Type.getObjectType(this.extensionClassName);
        this.originalType = Type.getObjectType(match.getOriginal().name);
        this.extensionTemplate = template;
        this.extensionNodeFieldNames = new HashSet<String>(this.extensionTemplate.fields.size());
        for (FieldNode fieldNode : this.extensionTemplate.fields) {
            this.extensionNodeFieldNames.add(fieldNode.name);
        }
    }

    public ClassNode generateExtensionClass() {
        SynchronizedClassNode extension = new SynchronizedClassNode();
        HashMap<String, String> oldToNew = new HashMap<String, String>(1);
        oldToNew.put(this.extensionTemplate.name, this.extensionClassName);
        oldToNew.put(this.extensionTemplate.superName, "java/lang/Object");
        ClassVisitor visitor = ReferenceUtils.getRenamingVisitor(oldToNew, extension);
        for (String newFieldName : this.match.getNewFields()) {
            visitor = this.updateCollidingFieldNames(visitor, newFieldName);
        }
        this.extensionTemplate.accept(visitor);
        extension.visit(WeaveUtils.RUNTIME_MAX_SUPPORTED_CLASS_VERSION, 33, this.extensionClassName, null, "java/lang/Object", this.extensionTemplate.interfaces.toArray(new String[this.extensionTemplate.interfaces.size()]));
        ClassNode weaveClass = this.match.getWeave();
        for (String newFieldName : this.match.getNewFields()) {
            FieldNode newField = WeaveUtils.findRequiredMatch(weaveClass.fields, newFieldName);
            int access = newField.access;
            access |= 1;
            FieldVisitor fv = ((ClassNode)extension).visitField(access &= 0xFFFFFFE9, newField.name, newField.desc, newField.signature, newField.value);
            fv.visitEnd();
        }
        if (this.match.getExtensionClassInit() != null) {
            AbstractInsnNode retInsn;
            MethodNode clinitMethodNode = WeaveUtils.getMethodNode(extension, "<clinit>", "()V");
            if (null == clinitMethodNode) {
                ((ClassNode)extension).visitMethod(8, "<clinit>", "()V", null, null);
                clinitMethodNode = WeaveUtils.getMethodNode(extension, "<clinit>", "()V");
                clinitMethodNode.visitCode();
                clinitMethodNode.visitInsn(177);
                clinitMethodNode.visitMaxs(0, 0);
                clinitMethodNode.visitEnd();
            }
            HashSet<MethodNode> toInline = new HashSet<MethodNode>();
            MethodNode classInit = this.rewriteNewFieldCalls(this.match.getExtensionClassInit());
            for (Method newMethod : this.match.getNewMethods()) {
                MethodNode newMethodNode = WeaveUtils.findMatch(this.match.getWeave().methods, newMethod);
                if (newMethodNode == null) continue;
                toInline.add(newMethodNode);
            }
            classInit = MethodProcessors.inlineMethods(weaveClass.name, toInline, this.extensionClassName, classInit);
            for (retInsn = clinitMethodNode.instructions.getLast(); retInsn != null && retInsn.getOpcode() != 177; retInsn = retInsn.getPrevious()) {
            }
            if (null != retInsn) {
                clinitMethodNode.instructions.remove(retInsn);
            }
            clinitMethodNode.instructions.add(classInit.instructions);
            clinitMethodNode.instructions.resetLabels();
        }
        extension.visitEnd();
        ((ClassNode)extension).visitMethod(1, RESET_CHECK_NAME, RESET_CHECK_DESC, null, null);
        MethodNode resetMethod = WeaveUtils.getMethodNode(extension, RESET_CHECK_NAME, RESET_CHECK_DESC);
        Label FALSE = new Label();
        for (String newFieldName : this.match.getNewFields()) {
            FieldNode newFieldNode = WeaveUtils.findMatch(this.match.getWeave().fields, newFieldName);
            if ((newFieldNode.access & 8) != 0) continue;
            this.writeFieldResetCheck(resetMethod, newFieldNode, FALSE);
        }
        resetMethod.visitInsn(4);
        resetMethod.visitInsn(172);
        resetMethod.visitLabel(FALSE);
        resetMethod.visitInsn(3);
        resetMethod.visitInsn(172);
        resetMethod.visitMaxs(0, 0);
        resetMethod.visitEnd();
        return extension;
    }

    private void writeFieldResetCheck(MethodNode methodNode, FieldNode fieldNode, Label FALSE) {
        Type fieldType = Type.getType(fieldNode.desc);
        methodNode.visitVarInsn(25, 0);
        methodNode.visitFieldInsn(180, this.getExtensionClassName(), fieldNode.name, fieldNode.desc);
        switch (fieldType.getSort()) {
            case 9: 
            case 10: {
                methodNode.visitJumpInsn(199, FALSE);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                methodNode.visitInsn(3);
                methodNode.visitJumpInsn(160, FALSE);
                break;
            }
            case 7: {
                methodNode.visitInsn(9);
                methodNode.visitInsn(148);
                methodNode.visitInsn(3);
                methodNode.visitJumpInsn(160, FALSE);
                break;
            }
            case 6: {
                methodNode.visitInsn(11);
                methodNode.visitInsn(149);
                methodNode.visitInsn(3);
                methodNode.visitJumpInsn(160, FALSE);
                break;
            }
            case 8: {
                methodNode.visitInsn(14);
                methodNode.visitInsn(151);
                methodNode.visitInsn(3);
                methodNode.visitJumpInsn(160, FALSE);
            }
        }
    }

    private ClassVisitor updateCollidingFieldNames(ClassVisitor visitor, String newFieldName) {
        FieldNode collidingField;
        if (this.extensionNodeFieldNames.contains(newFieldName)) {
            String renamedField = "ext_" + newFieldName;
            while (this.extensionNodeFieldNames.contains(renamedField) || this.match.getNewFields().contains(renamedField)) {
                renamedField = "ext_" + renamedField;
            }
            this.extensionNodeFieldNames.remove(newFieldName);
            this.extensionNodeFieldNames.add(renamedField);
            visitor = ReferenceUtils.getFieldRenamingVisitor(visitor, this.extensionTemplate.name, newFieldName, renamedField);
        }
        if (null != (collidingField = WeaveUtils.findMatch(this.extensionTemplate.fields, newFieldName))) {
            String renamedField = "ext_" + collidingField.name;
            while (null != WeaveUtils.findMatch(this.extensionTemplate.fields, renamedField) || this.match.getNewFields().contains(renamedField)) {
                renamedField = "ext_" + collidingField.name;
            }
            visitor = ReferenceUtils.getFieldRenamingVisitor(visitor, this.extensionTemplate.name, newFieldName, renamedField);
        }
        return visitor;
    }

    public MethodNode rewriteNewFieldCalls(MethodNode weaveMethod) {
        if (null != weaveMethod.instructions) {
            ArrayList<FieldInsnNode> newFieldInstructions = new ArrayList<FieldInsnNode>();
            for (AbstractInsnNode current = weaveMethod.instructions.getFirst(); null != current; current = current.getNext()) {
                if (5 == current.getType()) {
                    MethodInsnNode methodInsn = (MethodInsnNode)current;
                    if (methodInsn.owner.equals(this.match.getWeave().name)) {
                        Method key = new Method(methodInsn.name, methodInsn.desc);
                        GeneratedNewFieldMethod newFieldMethod = this.match.getGeneratedNewFieldMethods().get(key);
                        if (null != newFieldMethod) {
                            current = this.generatedAccessorCall(weaveMethod.instructions, methodInsn, newFieldMethod);
                        }
                    }
                }
                if (4 != current.getType()) continue;
                FieldInsnNode fieldInsn = (FieldInsnNode)current;
                if (!fieldInsn.owner.equals(this.match.getWeave().name) || !this.match.getNewFields().contains(fieldInsn.name)) continue;
                newFieldInstructions.add(fieldInsn);
            }
            int cachedExtSlot = -1;
            if (newFieldInstructions.size() > 1) {
                cachedExtSlot = PreparedExtension.createNewLocal(weaveMethod);
                InsnNode pushNull = new InsnNode(1);
                weaveMethod.instructions.insert(pushNull);
                weaveMethod.instructions.insert((AbstractInsnNode)pushNull, new VarInsnNode(58, cachedExtSlot));
            }
            for (FieldInsnNode fieldNode : newFieldInstructions) {
                this.newFieldCall(weaveMethod.instructions, fieldNode, cachedExtSlot);
            }
            if (newFieldInstructions.size() > 0) {
                weaveMethod.instructions.resetLabels();
            }
        }
        return weaveMethod;
    }

    private FieldInsnNode generatedAccessorCall(InsnList instructions, MethodInsnNode methodInsn, GeneratedNewFieldMethod newFieldMethod) {
        if (newFieldMethod.returnsPutValue) {
            int dupSize;
            int dupOpcode = newFieldMethod.opcode == 179 ? ((dupSize = newFieldMethod.method.getArgumentTypes()[0].getSize()) == 1 ? 89 : 92) : ((dupSize = newFieldMethod.method.getArgumentTypes()[1].getSize()) == 1 ? 90 : 93);
            instructions.insertBefore((AbstractInsnNode)methodInsn, new InsnNode(dupOpcode));
        }
        FieldInsnNode fieldInsn = new FieldInsnNode(newFieldMethod.opcode, methodInsn.owner, newFieldMethod.newFieldName, newFieldMethod.newFieldDesc);
        instructions.insert((AbstractInsnNode)methodInsn, fieldInsn);
        instructions.remove(methodInsn);
        return fieldInsn;
    }

    private void newFieldCall(InsnList instructions, FieldInsnNode fieldInsn, int cachedExtSlot) {
        if (181 == fieldInsn.getOpcode() || 180 == fieldInsn.getOpcode()) {
            Type fieldType = Type.getType(fieldInsn.desc);
            LabelNode beforeMapLoad = new LabelNode(new Label());
            LabelNode afterMapLoad = new LabelNode(new Label());
            ArrayList<AbstractInsnNode> removalCheckDups = new ArrayList<AbstractInsnNode>();
            instructions.insertBefore((AbstractInsnNode)fieldInsn, beforeMapLoad);
            if (181 == fieldInsn.getOpcode()) {
                PreparedExtension.swap(instructions, fieldInsn, fieldType, this.originalType);
                removalCheckDups.add(fieldInsn.getPrevious());
            }
            MethodInsnNode getExtensionClassInsn = new MethodInsnNode(184, this.extensionClassName, "getExtension", this.getExtensionMethodDesc(), false);
            instructions.insertBefore((AbstractInsnNode)fieldInsn, getExtensionClassInsn);
            instructions.insertBefore((AbstractInsnNode)fieldInsn, afterMapLoad);
            this.writeLocalVarCaching(instructions, fieldInsn, beforeMapLoad, afterMapLoad, removalCheckDups, cachedExtSlot);
            if (181 == fieldInsn.getOpcode()) {
                removalCheckDups.add(fieldInsn.getPrevious());
                PreparedExtension.swap(instructions, fieldInsn, this.extensionClassType, fieldType);
                LabelNode afterMapRemoval = this.writeRemovalCheck(instructions, fieldInsn, removalCheckDups);
                this.invalidateLocalVarCache(instructions, afterMapRemoval, cachedExtSlot);
            }
        }
        fieldInsn.owner = this.extensionClassName;
    }

    private void writeLocalVarCaching(InsnList instructions, FieldInsnNode fieldInsn, LabelNode beforeMapLoad, LabelNode afterMapLoad, List<AbstractInsnNode> removalCheckDups, int cachedExtSlot) {
        Type fieldType = Type.getType(fieldInsn.desc);
        if (cachedExtSlot != -1) {
            instructions.insertBefore((AbstractInsnNode)beforeMapLoad, new VarInsnNode(25, cachedExtSlot));
            instructions.insertBefore((AbstractInsnNode)beforeMapLoad, new JumpInsnNode(198, beforeMapLoad));
            if (181 == fieldInsn.getOpcode()) {
                PreparedExtension.swap(instructions, beforeMapLoad, fieldType, this.extensionClassType);
                removalCheckDups.add(beforeMapLoad.getPrevious());
            }
            instructions.insertBefore((AbstractInsnNode)beforeMapLoad, new InsnNode(87));
            instructions.insertBefore((AbstractInsnNode)beforeMapLoad, new JumpInsnNode(167, afterMapLoad));
            instructions.insertBefore((AbstractInsnNode)afterMapLoad, new VarInsnNode(58, cachedExtSlot));
            instructions.insert((AbstractInsnNode)afterMapLoad, new VarInsnNode(25, cachedExtSlot));
        }
    }

    private void invalidateLocalVarCache(InsnList instructions, AbstractInsnNode afterMapRemoval, int cachedExtSlot) {
        if (cachedExtSlot != -1) {
            instructions.insertBefore(afterMapRemoval, new InsnNode(1));
            instructions.insertBefore(afterMapRemoval, new VarInsnNode(58, cachedExtSlot));
        }
    }

    private LabelNode writeRemovalCheck(InsnList instructions, FieldInsnNode fieldInsn, List<AbstractInsnNode> removalCheckDups) {
        Type fieldType = Type.getType(fieldInsn.desc);
        for (AbstractInsnNode insertPoint : removalCheckDups) {
            PreparedExtension.dup_two_below(instructions, insertPoint.getNext(), this.originalType, fieldType);
        }
        LabelNode nfOpComplete = new LabelNode(new Label());
        LabelNode popOriginal = new LabelNode(new Label());
        LabelNode afterRemovalMapOp = new LabelNode(new Label());
        instructions.insert((AbstractInsnNode)fieldInsn, nfOpComplete);
        MethodInsnNode shouldResetInsn = new MethodInsnNode(182, this.extensionClassName, RESET_CHECK_NAME, RESET_CHECK_DESC, false);
        instructions.insertBefore((AbstractInsnNode)nfOpComplete, shouldResetInsn);
        instructions.insertBefore((AbstractInsnNode)nfOpComplete, new InsnNode(3));
        instructions.insertBefore((AbstractInsnNode)nfOpComplete, new JumpInsnNode(159, popOriginal));
        MethodInsnNode removeExtensionClassInsn = new MethodInsnNode(184, this.extensionClassName, "getAndRemoveExtension", this.getExtensionMethodDesc(), false);
        instructions.insertBefore((AbstractInsnNode)nfOpComplete, removeExtensionClassInsn);
        instructions.insertBefore((AbstractInsnNode)nfOpComplete, afterRemovalMapOp);
        instructions.insertBefore((AbstractInsnNode)nfOpComplete, new InsnNode(87));
        instructions.insertBefore((AbstractInsnNode)nfOpComplete, new JumpInsnNode(167, nfOpComplete));
        instructions.insertBefore((AbstractInsnNode)nfOpComplete, popOriginal);
        instructions.insertBefore((AbstractInsnNode)nfOpComplete, new InsnNode(87));
        return afterRemovalMapOp;
    }

    private static void dup_two_below(InsnList instructions, AbstractInsnNode insertPoint, Type stackTop, Type belowTop) {
        if (stackTop.getSize() == 1) {
            if (belowTop.getSize() == 1) {
                instructions.insertBefore(insertPoint, new InsnNode(90));
            } else {
                instructions.insertBefore(insertPoint, new InsnNode(91));
            }
        } else if (belowTop.getSize() == 1) {
            instructions.insertBefore(insertPoint, new InsnNode(93));
        } else {
            instructions.insertBefore(insertPoint, new InsnNode(94));
        }
    }

    private static void swap(InsnList instructions, AbstractInsnNode insertPoint, Type stackTop, Type belowTop) {
        if (stackTop.getSize() == 1) {
            if (belowTop.getSize() == 1) {
                instructions.insertBefore(insertPoint, new InsnNode(95));
            } else {
                instructions.insertBefore(insertPoint, new InsnNode(91));
                instructions.insertBefore(insertPoint, new InsnNode(87));
            }
        } else {
            if (belowTop.getSize() == 1) {
                instructions.insertBefore(insertPoint, new InsnNode(93));
            } else {
                instructions.insertBefore(insertPoint, new InsnNode(94));
            }
            instructions.insertBefore(insertPoint, new InsnNode(88));
        }
    }

    private static int createNewLocal(MethodNode method) {
        int newLocalIndex = 2 * method.maxLocals;
        ++method.maxLocals;
        return newLocalIndex;
    }

    public String getExtensionClassName() {
        return this.extensionClassName;
    }

    private String getExtensionMethodDesc() {
        return "(Ljava/lang/Object;)L" + this.extensionClassName + ";";
    }
}

