/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport.apache;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.apache.http.ssl.SSLContextBuilder;
import com.newrelic.agent.transport.DataSenderImpl;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;

public class ApacheSSLManager {
    public static SSLContext createSSLContext(boolean usePrivateSSL, boolean useSSL, String caBundlePath) {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        try {
            if (usePrivateSSL && useSSL) {
                sslContextBuilder.loadTrustMaterial(ApacheSSLManager.getKeyStore(caBundlePath), null);
            }
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, e, "Unable to create SSL context");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(String caBundlePath) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        Agent.LOG.finer("SSL Keystore Provider: " + keystore.getProvider().getName());
        InputStream in = DataSenderImpl.class.getResourceAsStream("/nrcerts");
        if (null == in) {
            Agent.LOG.severe("Unable to find NR trust store. No certificates will be imported.");
            return keystore;
        }
        LinkedList<X509Certificate> caCerts = new LinkedList<X509Certificate>();
        if (caBundlePath != null) {
            Agent.LOG.log(Level.FINEST, "Checking ca_bundle_path at: {0}", caBundlePath);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(caBundlePath));
            Object object = null;
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                while (((InputStream)is).available() > 0) {
                    try {
                        caCerts.add((X509Certificate)cf.generateCertificate(is));
                    }
                    catch (Throwable t) {
                        Agent.LOG.log(Level.SEVERE, "Unable to generate ca_bundle_path certificate. Will not process further certs.", t);
                        break;
                    }
                }
            }
            catch (Throwable cf) {
                object = cf;
                throw cf;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable cf) {
                            ((Throwable)object).addSuppressed(cf);
                        }
                    } else {
                        ((InputStream)is).close();
                    }
                }
            }
            Agent.LOG.log(caCerts.size() > 0 ? Level.INFO : Level.SEVERE, "Read ca_bundle_path {0} and found {1} certificates.", caBundlePath, caCerts.size());
        } else {
            Agent.LOG.finest("ca_bundle_path was not provided; only NR certificates will be included");
        }
        try {
            keystore.load(in, null);
            int i = 1;
            for (X509Certificate caCert : caCerts) {
                if (caCert != null) {
                    String alias = "ca_bundle_path_" + i;
                    keystore.setCertificateEntry(alias, caCert);
                    Agent.LOG.log(Level.FINEST, "Installed certificate {0} at alias: {1}", i, alias);
                    if (Agent.isDebugEnabled()) {
                        Agent.LOG.log(Level.FINEST, "Installed certificate {0} at alias: {1}", caCert, alias);
                    }
                }
                ++i;
            }
        }
        finally {
            in.close();
        }
        return keystore;
    }
}

