/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport.apache;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.apache.http.Header;
import com.newrelic.agent.deps.org.apache.http.HttpResponse;
import com.newrelic.agent.deps.org.apache.http.StatusLine;
import com.newrelic.agent.deps.org.apache.http.client.config.RequestConfig;
import com.newrelic.agent.deps.org.apache.http.client.methods.CloseableHttpResponse;
import com.newrelic.agent.deps.org.apache.http.client.methods.HttpUriRequest;
import com.newrelic.agent.deps.org.apache.http.client.methods.RequestBuilder;
import com.newrelic.agent.deps.org.apache.http.client.protocol.HttpClientContext;
import com.newrelic.agent.deps.org.apache.http.config.RegistryBuilder;
import com.newrelic.agent.deps.org.apache.http.config.SocketConfig;
import com.newrelic.agent.deps.org.apache.http.conn.HttpHostConnectException;
import com.newrelic.agent.deps.org.apache.http.conn.routing.HttpRoute;
import com.newrelic.agent.deps.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.newrelic.agent.deps.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.newrelic.agent.deps.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.newrelic.agent.deps.org.apache.http.entity.ByteArrayEntity;
import com.newrelic.agent.deps.org.apache.http.impl.client.CloseableHttpClient;
import com.newrelic.agent.deps.org.apache.http.impl.client.HttpClientBuilder;
import com.newrelic.agent.deps.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.newrelic.agent.deps.org.apache.http.message.BasicHeader;
import com.newrelic.agent.deps.org.apache.http.protocol.HttpContext;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.transport.HostConnectException;
import com.newrelic.agent.transport.HttpClientWrapper;
import com.newrelic.agent.transport.ReadResult;
import com.newrelic.agent.transport.apache.ApacheProxyManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;

public class ApacheHttpClientWrapper
implements HttpClientWrapper {
    private final ApacheProxyManager proxyManager;
    private final PoolingHttpClientConnectionManager connectionManager;
    private final CloseableHttpClient httpClient;
    private static final String USER_AGENT_HEADER_VALUE = ApacheHttpClientWrapper.initUserHeaderValue();

    public ApacheHttpClientWrapper(ApacheProxyManager proxyManager, SSLContext sslContext, int defaultTimeoutInMillis) {
        this.proxyManager = proxyManager;
        this.connectionManager = ApacheHttpClientWrapper.createHttpClientConnectionManager(sslContext);
        this.httpClient = this.createHttpClient(defaultTimeoutInMillis);
    }

    private static String initUserHeaderValue() {
        String arch = "unknown";
        String javaVersion = "unknown";
        try {
            arch = System.getProperty("os.arch");
            javaVersion = System.getProperty("java.version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MessageFormat.format("NewRelic-JavaAgent/{0} (java {1} {2})", Agent.getVersion(), javaVersion, arch);
    }

    private static PoolingHttpClientConnectionManager createHttpClientConnectionManager(SSLContext sslContext) {
        PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)(sslContext != null ? new SSLConnectionSocketFactory(sslContext) : SSLConnectionSocketFactory.getSocketFactory()))).build());
        httpClientConnectionManager.setMaxTotal(1);
        httpClientConnectionManager.setDefaultMaxPerRoute(1);
        return httpClientConnectionManager;
    }

    private CloseableHttpClient createHttpClient(int requestTimeoutInMillis) {
        HttpClientBuilder builder = HttpClientBuilder.create().setUserAgent(USER_AGENT_HEADER_VALUE).setDefaultHeaders(Arrays.asList(new BasicHeader("Connection", "Keep-Alive"), new BasicHeader("CONTENT-TYPE", "application/json"), new BasicHeader("ACCEPT-ENCODING", "gzip"))).setSSLHostnameVerifier(new DefaultHostnameVerifier()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(requestTimeoutInMillis).setConnectionRequestTimeout(requestTimeoutInMillis).setSocketTimeout(requestTimeoutInMillis).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(requestTimeoutInMillis).setSoKeepAlive(true).build()).setConnectionManager(this.connectionManager);
        if (this.proxyManager.getProxy() != null) {
            builder.setProxy(this.proxyManager.getProxy());
        }
        return builder.build();
    }

    @Override
    public void shutdown() {
        this.connectionManager.closeIdleConnections(0L, TimeUnit.SECONDS);
    }

    @Override
    public void captureSupportabilityMetrics(StatsService statsService, String requestHost) {
        Set<HttpRoute> routes = this.connectionManager.getRoutes();
        boolean willReuse = false;
        for (HttpRoute route : routes) {
            String hostName = route.getTargetHost().getHostName();
            if (hostName == null || !hostName.equals(requestHost)) continue;
            statsService.doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/Agent/Collector/Connection/Reused", 1));
            willReuse = true;
        }
        if (!willReuse) {
            statsService.doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/Agent/Collector/Connection/New", 1));
        }
    }

    private HttpContext createContext() {
        return this.proxyManager.updateContext(HttpClientContext.create());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadResult execute(HttpClientWrapper.Request request, HttpClientWrapper.ExecuteEventHandler handler) throws Exception {
        HttpUriRequest apacheRequest = this.mapRequestToApacheRequest(request);
        if (handler != null) {
            handler.requestStarted();
        }
        try (CloseableHttpResponse response = this.httpClient.execute(apacheRequest, this.createContext());){
            if (handler != null) {
                handler.requestEnded();
            }
            ReadResult readResult = this.mapResponseToResult(response);
            return readResult;
        }
        catch (HttpHostConnectException hostConnectException) {
            throw new HostConnectException(hostConnectException.getHost().toString(), hostConnectException);
        }
    }

    private HttpUriRequest mapRequestToApacheRequest(HttpClientWrapper.Request request) throws URISyntaxException {
        RequestBuilder requestBuilder = null;
        switch (request.getVerb()) {
            case POST: {
                requestBuilder = RequestBuilder.post();
                break;
            }
            case PUT: {
                requestBuilder = RequestBuilder.put();
            }
        }
        requestBuilder.setUri(request.getURL().toURI()).setHeader(new BasicHeader("CONTENT-ENCODING", request.getEncoding())).setEntity(new ByteArrayEntity(request.getData()));
        for (Map.Entry<String, String> entry : request.getRequestMetadata().entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        return requestBuilder.build();
    }

    private ReadResult mapResponseToResult(HttpResponse response) throws Exception {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine == null) {
            throw new Exception("HttpClient returned null status line");
        }
        String proxyAuthenticateValue = this.getFirstProxyAuthenticateHeader(response);
        return ReadResult.create(statusLine.getStatusCode(), this.readResponseBody(response), proxyAuthenticateValue);
    }

    private String getFirstProxyAuthenticateHeader(HttpResponse response) {
        String proxyAuthenticateValue = null;
        Header proxyAuthenticateHeader = response.getFirstHeader("Proxy-Authenticate");
        if (proxyAuthenticateHeader != null) {
            proxyAuthenticateValue = proxyAuthenticateHeader.getValue();
        }
        return proxyAuthenticateValue;
    }

    /*
     * Exception decompiling
     */
    private String readResponseBody(HttpResponse response) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BufferedReader getBufferedReader(HttpResponse response, InputStream is) throws IOException {
        String encoding;
        Header encodingHeader = response.getFirstHeader("content-encoding");
        if (encodingHeader != null && "gzip".equals(encoding = encodingHeader.getValue())) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }
}

