/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionStateImpl;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.AbstractTracerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;

public class ServletAsyncTransactionStateImpl
extends TransactionStateImpl {
    private static final ClassMethodSignature ASYNC_PROCESSING_SIG = new ClassMethodSignature("NR_RECORD_ASYNC_PROCESSING_CLASS", "NR_RECORD_ASYNC_PROCESSING_METHOD", "()V");
    private static final MetricNameFormat ASYNC_PROCESSING_FORMAT = new SimpleMetricNameFormat("AsyncProcessing");
    private static final TracerFactory ASYNC_TRACER_FACTORY = new AsyncTracerFactory();
    private final Transaction transaction;
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private volatile Tracer rootTracer;
    private volatile AbstractTracer asyncProcessingTracer;

    public ServletAsyncTransactionStateImpl(Transaction tx) {
        this.transaction = tx;
    }

    @Override
    public Tracer getTracer(Transaction tx, TracerFactory tracerFactory, ClassMethodSignature signature, Object object, Object ... args) {
        Tracer tracer;
        if (this.state.compareAndSet(State.RESUMING, State.RUNNING) && (tracer = this.resumeRootTracer()) != null) {
            return tracer;
        }
        return super.getTracer(tx, tracerFactory, signature, object, args);
    }

    @Override
    public Tracer getRootTracer() {
        if (this.state.compareAndSet(State.RESUMING, State.RUNNING)) {
            return this.resumeRootTracer();
        }
        return null;
    }

    @Override
    public void resume() {
        if (!this.state.compareAndSet(State.SUSPENDING, State.RESUMING)) {
            return;
        }
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.finer(MessageFormat.format("Resuming transaction {0}", this.transaction));
        }
        Transaction.clearTransaction();
        Transaction.setTransaction(this.transaction);
    }

    @Override
    public void suspendRootTracer() {
        Transaction currentTx = Transaction.getTransaction(false);
        if (this.transaction != currentTx) {
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.finer(MessageFormat.format("Unable to suspend transaction {0} because it is not the current transaction {1}", this.transaction, currentTx));
            }
            return;
        }
        if (!this.state.compareAndSet(State.RUNNING, State.SUSPENDING)) {
            return;
        }
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.finer(MessageFormat.format("Transaction {0} is suspended", this.transaction));
        }
    }

    @Override
    public void complete() {
        Transaction currentTx;
        if (!this.state.compareAndSet(State.SUSPENDING, State.RUNNING)) {
            return;
        }
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.finer(MessageFormat.format("Completing transaction {0}", this.transaction));
        }
        if ((currentTx = Transaction.getTransaction(false)) != this.transaction) {
            Transaction.clearTransaction();
            Transaction.setTransaction(this.transaction);
        }
        try {
            Tracer tracer = this.resumeRootTracer();
            if (tracer != null) {
                tracer.finish(176, null);
            }
        }
        finally {
            if (currentTx != this.transaction) {
                Transaction.clearTransaction();
                if (currentTx != null) {
                    Transaction.setTransaction(currentTx);
                }
            }
        }
    }

    @Override
    public boolean finish(Transaction tx, Tracer tracer) {
        if (this.state.get() == State.SUSPENDING && tracer == tx.getRootTracer()) {
            this.suspendRootTracer(tx, tx.getRootTracer());
            return false;
        }
        return true;
    }

    private void suspendRootTracer(Transaction tx, Tracer tracer) {
        this.rootTracer = tracer;
        this.startAsyncProcessingTracer(tx);
        Transaction.clearTransaction();
    }

    private void startAsyncProcessingTracer(Transaction tx) {
        if (this.asyncProcessingTracer == null) {
            this.asyncProcessingTracer = (AbstractTracer)super.getTracer(tx, ASYNC_TRACER_FACTORY, ASYNC_PROCESSING_SIG, null, (Object[])null);
        }
    }

    private Tracer resumeRootTracer() {
        this.stopAsyncProcessingTracer();
        Tracer tracer = this.rootTracer;
        this.rootTracer = null;
        return tracer;
    }

    private void stopAsyncProcessingTracer() {
        if (this.asyncProcessingTracer != null) {
            this.asyncProcessingTracer.finish(176, null);
        }
        this.asyncProcessingTracer = null;
    }

    private static class AsyncTracerFactory
    extends AbstractTracerFactory {
        private AsyncTracerFactory() {
        }

        @Override
        public Tracer doGetTracer(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) {
            return new DefaultTracer(tx, sig, object, ASYNC_PROCESSING_FORMAT);
        }
    }

    private static enum State {
        RESUMING,
        RUNNING,
        SUSPENDING;

    }
}

